/*****************************************************************************
 * $Id: runtime.c,v 1.2 2005/08/23 11:55:38 killabyte Exp $
 *
 * Simple runtime backend with pthreads support.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<backend.h>
#include<log.h>
#include<pdiconfig.h>
#include<threadid.h>
#include<pthread.h>

#define FALSE 0
#define TRUE (1==1)

/* Esta es la tabla que contendr la relacin de threads en ejecucin */
pthread_t *thconv = NULL;

/* Usaremos un mutex para hacer los accesos a la tabla de forma atmica */
pthread_mutex_t mutex_thconv = PTHREAD_MUTEX_INITIALIZER;

/* Esta funcin ser la encarga de darle un identificador al thread */
static int idres(void)
{
  int i;
  int fz;
  pthread_t pt;

  if(thconv)
  {
    /* Buscamos el thread */
    pthread_mutex_lock(&mutex_thconv);
    pt = pthread_self();
    fz = PDICFG.max_threads + 1;
    for(i = 0; i < PDICFG.max_threads; i++)
    {
      /* si lo encontramos lo devolvemos */
      if(thconv[i] == pt)
      {
        pthread_mutex_unlock(&mutex_thconv);
        return i;
      }
      /* nos apuntamos esta posicin, si est libre */
      if(fz > PDICFG.max_threads && !thconv[i])
        fz = i;
    }

    /* no hemos encontrado el thread, lo damos de alta */
    thconv[fz] = pt;
    pthread_mutex_unlock(&mutex_thconv);

    return fz;
  } else
    return 0;
}

/* este wrapper se encargar de interceptar la muerte de un */
/* thread y as darlo de baja en la tabla 'thconv'          */
int pthread_exit_wrapper(void *ret)
{
  int id;

  if(thconv)
  {
    id = idres();
    _pdi_log(THIS, "killing %d\n", id);
    thconv[id] = 0;
  }

  pthread_exit(ret);
}

/* funciones de inicializacin y finalizacin */
int PDI_BE_FUNC_INIT(void)
{
  _pdi_log(THIS, "Initializing backend '" __FILE__ "'.\n");

  if(PDICFG.max_threads > 0)
  {
    if((thconv = malloc(sizeof(int) * PDICFG.max_threads)) == NULL)
    {
      _pdi_error(THIS, "No memory for 'thconv'.");
      return FALSE;
    }

    memset(thconv, 0, sizeof(int) * PDICFG.max_threads);

    _pdi_ebe_setThreadIdResolver(idres);
  } else {
    _pdi_log(THIS, "This program does not use threads.");
  }

  return TRUE;
}

void PDI_BE_FUNC_FINI(void)
{
  _pdi_log(THIS, "Closing backend '" __FILE__ "'.\n");

  if(thconv)
  {
    free(thconv);
    thconv = NULL;
    _pdi_ebe_setThreadIdResolver(NULL);
  }
}

