#!/bin/sh
###############################################################################
# $Id: runtest.sh.in,v 1.1 2005/08/23 10:59:36 killabyte Exp $
#
# Script that executes and instruments the test program.
#
# -----------------------------------------------------------------------------
# pDI-Tools - portable Dynamic Instrumentation Tools
#   (C) 2004, 2005 Gerardo Garca Pea
#   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2.1 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#   USA
#
###############################################################################

PLATFORM_OS="PDI_OS_LINUX"

LD_LIBRARY_PATH="./"
LD_BIND_NOW=1
export LD_LIBRARY_PATH LD_BIND_NOW

case $PLATFORM_OS in
PDI_OS_IRIX)
  _RLD_LIST="libpdi.so:DEFAULT" ./testpdi
  ;;
PDI_OS_LINUX)
  LD_PRELOAD=libpdi.so ./testpdi
  ;;
PDI_OS_SOLARIS)
  LD_PRELOAD=libpdi.so ./testpdi
  ;;
*)
  echo "I don't know how to run a test in this operating system: $PLATFORM_OS"
esac

