/*****************************************************************************
 * $Id: log.c,v 1.1 2005/08/08 22:50:51 killabyte Exp $
 *
 * This file implements a simple log system that will give a nice uniformity to
 * all messages of pDI-Tools & modules (backends, for instance).
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<pdiconfig.h>
#include<log.h>
#include<safefunc.h>

void _pdi_debug(char *file, char *function, char *format, ...)
{
  va_list args;

  if(PDICFG.verbose < LOG_LEVEL_DEBUG)
    return;

  va_start(args, format);
  if(file)     _pdi_safe_fprintf(PDICFG.logfile, "%s:", file);
  if(function) _pdi_safe_fprintf(PDICFG.logfile, "%s:", function);
  _pdi_safe_fputs("DEBUG:", PDICFG.logfile);
  _pdi_safe_vfprintf(PDICFG.logfile, format, args);
  _pdi_safe_fputc('\n', PDICFG.logfile);
  va_end(args);
}

void _pdi_log(char *file, char *function, char *format, ...)
{
  va_list args;

  if(PDICFG.verbose < LOG_LEVEL_LOG)
    return;

  va_start(args, format);
  if(file)     _pdi_safe_fprintf(PDICFG.logfile, "%s:", file);
  if(function) _pdi_safe_fprintf(PDICFG.logfile, "%s:", function);
  _pdi_safe_vfprintf(PDICFG.logfile, format, args);
  _pdi_safe_fputc('\n', PDICFG.logfile);
  va_end(args);
}

void _pdi_log_level(int level, char *file, char *function, char *format, ...)
{
  va_list args;
  char *type;

  if(level > LOG_LEVEL_ERROR && PDICFG.verbose < level)
    return;

  switch(level)
  {
    case LOG_LEVEL_DEBUG:   type = "DEBUG:";   break;
    case LOG_LEVEL_LOG:     type = "";         break;
    case LOG_LEVEL_WARNING: type = "warning:"; break;
    case LOG_LEVEL_ERROR:   type = "ERROR:";   break;
    default:
      _pdi_error(THIS, "Unknown log level when printing message '%s'.", format);
      return;
  }

  va_start(args, format);
  if(file)     _pdi_safe_fprintf(PDICFG.logfile, "%s:", file);
  if(function) _pdi_safe_fprintf(PDICFG.logfile, "%s:", function);
  _pdi_safe_fputs(type, PDICFG.logfile);
  _pdi_safe_vfprintf(PDICFG.logfile, format, args);
  _pdi_safe_fputc('\n', PDICFG.logfile);
  va_end(args);
}

void _pdi_warning(char *file, char *function, char *format, ...)
{
  va_list args;

  if(PDICFG.verbose < LOG_LEVEL_WARNING)
    return;

  va_start(args, format);
  if(file)     _pdi_safe_fprintf(PDICFG.logfile, "%s:", file);
  if(function) _pdi_safe_fprintf(PDICFG.logfile, "%s:", function);
  _pdi_safe_fputs("warning:", PDICFG.logfile);
  _pdi_safe_vfprintf(PDICFG.logfile, format, args);
  _pdi_safe_fputc('\n', PDICFG.logfile);
  va_end(args);
}

void _pdi_error(char *file, char *function, char *format, ...)
{
  va_list args;

  va_start(args, format);
  if(file)     _pdi_safe_fprintf(PDICFG.logfile, "%s:", file);
  if(function) _pdi_safe_fprintf(PDICFG.logfile, "%s:", function);
  _pdi_safe_fputs("ERROR:", PDICFG.logfile);
  _pdi_safe_vfprintf(PDICFG.logfile, format, args);
  _pdi_safe_fputc('\n', PDICFG.logfile);
  va_end(args);
}

