/*****************************************************************************
 * $Id: lx-threadid.c,v 1.1 2005/08/28 19:19:38 killabyte Exp $
 *
 * Functions needed by module 'genwrapper-i386.S'. In this file are defined
 * functions used to get which callback stack should be used by the running
 * thread, push and pop information, etc.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<ebeif.h>
#include<threadid.h>

/*****************************************************************************
 * PDI_CB_STACK_ENTRY
 *   This structure is the block that will be pushed/poped from the callback
 *   stack. In this structure is saved the running context of a function.
 *
 *   NOTE: The file 'genwrapper-i386.S' expects that this structure does not
 *   change. If you pretend to modify this structure probably you will have to
 *   adapt the code of 'genwrapper-i386.S'.
 *
 *****************************************************************************/

typedef struct _tag_PDI_CB_STACK_ENTRY {
  int                 eax;
  int                 ebx;
  int                 thid;
  int                 idfunc;
  PDI_LINUX_INTERCEPT *r;
  void                *func_addr;
  void                *ret_addr;
} PDI_CB_STACK_ENTRY;

/*****************************************************************************
 * PDI_CB_STACK_ENTRY *
 *   _pdi_linux_pushStateOnThreadCallbackStack(PDI_LINUX_INTERCEPT *r,
 *                                             void *func_addr,
 *                                             void *ret_addr,
 *                                             int idfunc,
 *                                             int ebx,
 *                                             int eax)
 *
 * Description:
 *   Save all the information passed throught parameters to the current
 *   callback stack. This function returns a pointer to te pushed element
 *   (PDI_CB_STACK_ENTRY *).
 *
 *   NOTE: This function is called from assembly code, so it is not recommended
 *         to modify the parameters: it could be too much funny.
 *
 * Parameters:
 *   r         - interposition address
 *   func_addr - address of the intercepted function
 *   ret_addr  - return address
 *   idfunc    - event id (function)
 *   ebx       - EBX value
 *   eax       - EAX value
 *
 * Returns:
 *   A pointer to the PDI_CB_STACK_ENTRY pushed in stack.
 *
 *****************************************************************************/

PDI_CB_STACK_ENTRY *
  _pdi_linux_pushStateOnThreadCallbackStack(PDI_LINUX_INTERCEPT *r,
                                            void *func_addr,
                                            void *ret_addr,
                                            int idfunc,
                                            int ebx,
                                            int eax)
{
  register char **stack_entry;
  register PDI_CB_STACK_ENTRY *entry;
  int thid;

  /* get a pointer to the current thread callback stack and push space */
  stack_entry = _pdi_ebe_getThreadCallbackStack(&thid);
  entry = (PDI_CB_STACK_ENTRY *) *stack_entry;
  *stack_entry += sizeof(PDI_CB_STACK_ENTRY);

  /* save data in stack */
  entry->eax       = eax;
  entry->ebx       = ebx;
  entry->thid      = thid;
  entry->idfunc    = idfunc;
  entry->r         = r;
  entry->func_addr = func_addr;
  entry->ret_addr  = ret_addr;

  return entry;
}

/*****************************************************************************
 * PDI_CB_STACK_ENTRY *_pdi_linux_popStateOnThreadCallbackStack(void)
 *
 * Description:
 *   Pop a PDI_CB_STACK_ENTRY structure from the current thread callback stack.
 *
 * Parameters:
 *   none.
 *
 * Returns:
 *   A pointer to the PDI_CB_STACK_ENTRY structure.
 *
 *****************************************************************************/

PDI_CB_STACK_ENTRY *_pdi_linux_popStateOnThreadCallbackStack(void)
{
  register char **stack_entry;

  stack_entry = _pdi_ebe_getThreadCallbackStack(NULL);
  *stack_entry -= sizeof(PDI_CB_STACK_ENTRY);

  return (PDI_CB_STACK_ENTRY *) *stack_entry;
}

