/*****************************************************************************
 * $Id: lx-rules.c,v 1.1 2005/08/28 18:38:16 killabyte Exp $
 *
 * Functions which are responsible of the arch dependant part of interposition
 * structures (PDI_INTERCEPT).
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<ebeif.h>
#include<log.h>

/*****************************************************************************
 * int _pdi_linux_newInterposition(PDI_ELFOBJ *eo,
 *                                 char *wname,
 *                                 PDI_INTERCEPT *i)
 *
 * Description:
 *   Reserva memoria para, e inicializa, la parte dependiente de la
 *   arquitectura de una interposicin.
 *
 * Parameters:
 *   eo    - object which belongs interposition
 *   wname - interposed function (wrapper)
 *   i     - interposition
 *
 * Returns:
 *   0 if all ok, a negative value otherwise.
 *
 *****************************************************************************/

int _pdi_linux_newInterposition(PDI_ELFOBJ *eo, char *wname, PDI_INTERCEPT *i)
{
  if((i->i_arch = malloc(sizeof(PDI_LINUX_INTERCEPT))) == NULL)
  {
    _pdi_error(THIS, "Cannot alloc memory.");
    return -1;
  }

  memset(i->i_arch, 0, sizeof(PDI_LINUX_INTERCEPT));

  return 0;
}

/*****************************************************************************
 * void _pdi_linux_freeInterposition(PDI_ELFOBJ *eo, PDI_INTERCEPT *i)
 *
 * Description:
 *   Free memory used by the arch dependant part of a interposition.
 *
 * Parameters:
 *   eo - object which belongs interposition
 *   i  - interposition
 *
 * Returns:
 *   nothing.
 *
 *****************************************************************************/

void _pdi_linux_freeInterposition(PDI_ELFOBJ *eo, PDI_INTERCEPT *i)
{
  if(!i->i_arch)
    return;

  free(i->i_arch);
  i->i_arch = NULL;
}

