/*****************************************************************************
 * $Id: lx-init.c,v 1.1 2005/08/28 13:58:06 killabyte Exp $
 *
 * Elf Backend initialization code.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<pdiconfig.h>
#include<ebeif.h>
#include<log.h>

unsigned int _pdi_linux_vlibc;

int _pdi_linux_init(void)
{
  unsigned int vlibc_maj,
               vlibc_min,
               vlibc_rev;

  /* Guess what version of the _r_debug protocol uses this Linux... */
  /* and if it is supported by this version of pDI-Tools            */
  _pdi_log(THIS, "_r_debug protocol version: '%d'",  _r_debug.r_version);
  if(_r_debug.r_version < LINUX_R_DEBUG_VER_MIN
  || _r_debug.r_version > LINUX_R_DEBUG_VER_MAX)
  {
    _pdi_error(THIS, "This _r_debug protocol version (%d) is not supported.",
               _r_debug.r_version);
    return -1;
  }

  /* Guess what GNU libc version is being used and check if it is supported */
  _pdi_log(THIS, "GNU libc version: %s (%s)",
           gnu_get_libc_version(), gnu_get_libc_release());
  if(sscanf(gnu_get_libc_version(), "%u.%u.%u",
            &vlibc_maj, &vlibc_min, &vlibc_rev) != 3)
  {
    _pdi_error(THIS, "GNU libc version string cannot be parsed: '%s'",
               gnu_get_libc_version());
    return -1;
  }
  _pdi_linux_vlibc = LINUX_LIBC_VABS(vlibc_maj, vlibc_min, vlibc_rev);
  if(_pdi_linux_vlibc < LINUX_LIBC_MINVER
  || _pdi_linux_vlibc > LINUX_LIBC_MAXVER)
  {
    _pdi_error(THIS, "This GNU libc version (%s) is not supported.",
               gnu_get_libc_version());
    return -1;
  }

  /* If debug mode is enabled then execute specific checks for this platform */
  if(PDICFG.debug)
    _pdi_linux_debug_checkSections();

  return 0;
}

