/*****************************************************************************
 * $Id: genwrapper-i386.S,v 1.1 2005/08/26 10:41:30 killabyte Exp $
 *
 * This file constains a 'generic wrapper' wrote in assembler specific for
 * Linux. It is the classical example of things that NEVER has to be made with
 * assembler by people with ethic and a good taste.
 *
 * The code that calls to this generic wrapper must follow this rules:
 *
 *   + it should put in stack these values (first element of this list is the
 *     top of the stack):
 *
 *      - address of the interposition PDI_INTERCEPT (@interposition)
 *      - pointer to the name of the wrapped (intercepted) function (@funcname)
 *      - address of the interposed function (@wrapped_func)
 *      - the RET return address.
 *
 *   + the value of EAX will be lost, it is not important and it is a luck it
 *     is lost.
 *
 * This 'generic wrapper' usually is called from a stub of this form:
 *
 *      push    WRAPPER
 *      push    SYM_NAME
 *      push    DIR_INTERCEPT
 *      jmp     _pdi_linux_genericWrapper
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<autoconfig.h>

/* Our stack vision from EBP... these constants are only usuable almost to */
/* tag WRAP_2, and not always.. From there the stack is a true caos that   */
/* must be treated very carefully.                                         */
#define PARAM_EBP                 0
#define PARAM_PDI_INTR            (PARAM_EBP      + 4)
#define PARAM_FUNCNAME            (PARAM_PDI_INTR + 4)
#define PARAM_WRAPPED             (PARAM_FUNCNAME + 4)
#define PARAM_RET_ADDR            (PARAM_WRAPPED  + 4)

/* PDI_ARCH_INTERCEPT fields offsets... is a pity that gAS */
/* does not allow to work with structures :'(              */
#define PDI_INTR_ARCH_CB_UNDO     0
#define PDI_INTR_ARCH_CB_BECBREQ  (PDI_INTR_ARCH_CB_UNDO    + SIZEOF_VOID_P)
#define PDI_INTR_ARCH_CB_BEPREEV  (PDI_INTR_ARCH_CB_BECBREQ + SIZEOF_VOID_P)
#define PDI_INTR_ARCH_CB_BEPOSTEV (PDI_INTR_ARCH_CB_BEPREEV + SIZEOF_VOID_P)

/* PDI_CB_STACK_ENTRY fields offsets. Another fright. This structure is */
/* defined in file 'linux/lx-threadid.c'.                               */
#define PDI_CBSE_EAX              0
#define PDI_CBSE_EBX              (PDI_CBSE_EAX       + SIZEOF_INT)
#define PDI_CBSE_THID             (PDI_CBSE_EBX       + SIZEOF_INT)
#define PDI_CBSE_IDFUNC           (PDI_CBSE_THID      + SIZEOF_INT)
#define PDI_CBSE_R                (PDI_CBSE_IDFUNC    + SIZEOF_INT)
#define PDI_CBSE_FUNC_ADDR        (PDI_CBSE_R         + SIZEOF_VOID_P)
#define PDI_CBSE_RET_ADDR         (PDI_CBSE_FUNC_ADDR + SIZEOF_VOID_P)

.text
        .align 4
.globl _pdi_linux_genericWrapper
        .type _pdi_linux_genericWrapper,@function

_pdi_linux_genericWrapper:
        /* Save EBP to access stack parameters */
        pushl   %ebp
        mov     %esp, %ebp

        /* Save EAX */
        pushl   %eax

        /* Ask to the callback handler if this function must be processed */
        /* (passing to di_callback_required() the function name)          */
        pushl   PARAM_FUNCNAME(%ebp)
        movl    PARAM_PDI_INTR(%ebp), %eax
        call    *PDI_INTR_ARCH_CB_BECBREQ(%eax)
        addl    $4, %esp
        cmpl    $0, %eax
        jnz     WRAP

        /* The CBhandler decided not to monitorize this func... fix the */
        /* stack and jump to the function now                           */
        popl    %eax
        popl    %ebp
        addl    $8, %esp

        /* Something bizarre: the address of the wrapped func is in stack, */
        /* so we use a 'ret' to transfer control to it.                    */
        ret



        /* Wrapping the function */
WRAP:   
        /* Saving in OUR STACK these values:                          */
        /*   - EAX (push is done at the start of the generic wrapper) */
        /*   - EBX                                                    */
        /*   - idfunc                                                 */
        /*   - ret_addr                                               */
        /*   - func_addr                                              */
        /*   - the intercept info PDI_INTR                            */
        /* at the end, EAX will contain the @ to the top of our stack */
        pushl   %ebx                   /* EBX            */
        pushl   %eax                   /* function id    */
        pushl   PARAM_RET_ADDR(%ebp)   /* ret_addr       */
        pushl   PARAM_WRAPPED(%ebp)    /* func_addr      */
        pushl   PARAM_PDI_INTR(%ebp)   /* PDI_LINUX_INTR */

        call    _pdi_linux_pushStateOnThreadCallbackStack

        /* Copy the address to the top OUR stack to EBX */
        movl    %eax, %ebx

        /* Pop the function parameters, restoring the value of EBP and  */
        /* removing the stub parametes, so the stack will have the same */
        /* aspect as it was a direct call to the wrapped function. But  */
        /* the return address will be removed: doing this, the function */
        /* di_pre_event_callback will can access to the intercepted     */
        /* function parameters directly.                                */
        addl    $24, %esp
        popl    %ebp
        addl    $16, %esp

        /* Call to 'di_pre_event_callback' (if it exists) */
        movl    PDI_CBSE_R(%eax), %eax
        movl    PDI_INTR_ARCH_CB_BEPREEV(%eax), %eax
        cmp     $0, %eax
        je      AFTER_PRE

        /* the function exists so we must push two things on stack: */
        /* the 'event_id' ([EBX-16]) and the 'virtual_processor'    */
        pushl   PDI_CBSE_IDFUNC(%ebx)
        pushl   PDI_CBSE_THID(%ebx)
        call    *%eax
        addl    $8, %esp

AFTER_PRE:
        /* Now we are going to call the intercepted function, so we must     */
        /* change the returning address to transfer control to the generic   */
        /* wrapper when it returns. The exact address will be at WRAP_2 tag, */
        /* just after the 'ret' instruction.                                 */

        /* Bizarre moments: prepare the stack to jump to the function with a */
        /* 'ret' instruction, and return from it with another 'ret': that's  */
        /* the reason for the strange 'push' instructions. Restore also the  */
        /* original values of 'EAX' and 'EBX'.                               */

        pushl   $WRAP_2
        pushl   PDI_CBSE_FUNC_ADDR(%ebx)
        mov     PDI_CBSE_EAX(%ebx), %eax
        mov     PDI_CBSE_EBX(%ebx), %ebx
        ret

WRAP_2:
        /* Save the function return value and make space to */
        /* put the return address                           */
        subl    $4, %esp
        pushl   %ebx
        pushl   %eax

        /* Push the saved values from on OUR stack */
        call    _pdi_linux_popStateOnThreadCallbackStack
        movl    %eax, %ebx

        /* Well ... now it is time to call the POST-POLLAS event handler */
        /* (if it exists, of course...)                                  */
        movl    PDI_CBSE_R(%ebx), %eax
        movl    PDI_INTR_ARCH_CB_BEPOSTEV(%eax), %eax
        cmp     $0, %eax
        je      AFTER_POST

        pushl   PDI_CBSE_IDFUNC(%ebx)
        pushl   PDI_CBSE_THID(%ebx)
        call    *%eax
        addl    $8, %esp

AFTER_POST:
        /* That's all! restore EAX and EBX values, push in stack */
        /* the intercepted function return address and return!   */
        movl    PDI_CBSE_RET_ADDR(%ebx), %eax
        movl    %eax, 8(%esp)
        popl    %eax
        popl    %ebx
        ret

