/*****************************************************************************
 * $Id: ix-elfops.c,v 1.1 2005/08/26 09:14:46 killabyte Exp $
 *
 * Operations on ELF structures.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<ebeif.h>

ElfW(Phdr) *_pdi_irix_findProgramHeader(ElfW(Obj_Info) *oi, ElfW(Word) type)
{
  ElfW(Ehdr) *eh;
  ElfW(Phdr) *ph;
  int i;

  eh = ((ElfW(Ehdr) *) oi->oi_ehdr);
  ph = (ElfW(Phdr) *) (((ElfW(Addr)) eh) + eh->e_phoff);

  for(i = 0; i < eh->e_phnum; i++, ph++)
    if(ph->p_type == type)
      return ph;

  return NULL;
}

ElfW(Dyn) *_pdi_irix_getFirstDynEntry(ElfW(Obj_Info) *oi)
{
  ElfW(Phdr) *ph_dyn;

  /* Search Program Header in this segment */
  ph_dyn = _pdi_irix_findProgramHeader(oi, PT_DYNAMIC);

  /* return the first entry */
  return (ElfW(Dyn) *) (ph_dyn->p_vaddr + (oi->oi_ehdr - oi->oi_orig_ehdr));
}
