/*****************************************************************************
 * $Id: init.c,v 1.1 2005/08/02 11:48:13 killabyte Exp $
 *
 * This file contains pDI-Tools initialization code. This code is executed
 * before instrumented main application program and initialization code of
 * libraries used by it.
 *
 * Finalization code of pDI-Tools can be found in file 'fini.c'.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<pdiconfig.h>
#include<beconfig.h>
#include<ebeif.h>
#include<threadid.h>
#include<log.h>
#include<safefunc.h>

static void initLiblink(void)  __attribute__ ((constructor));

static void initLiblink(void)
{
  BECFG_CONFIG *becfg, *tmpcfg;
  char **p;

  /* Get temporal (non secure) pointers to functions */
  if(_pdi_initSafeFuncs())
  {
    fprintf(stderr, PACKAGE ":error:Cannot initialize functions _pdi_safe_*\n");
    exit(1);
  }

  /* Load pDI-Tools configuration (from env vars, config files, Oracle */
  /* databases, LDAP directories, etc...) This configuration will set  */
  /* libpdi.so parameters, and which interposition commands files will */
  /* be used.                                                          */
  if(_pdi_loadConfiguration())
  {
    _pdi_error(THIS, "Cannot find a configuration for pDI-Tools.");
    exit(1);
  }

  /* Show name, version and copyright of this program */
  _pdi_log(NULL, NULL, "----------------------------------------------------------------------");
  _pdi_log(NULL, NULL, PACKAGE_NAME " version " PACKAGE_VERSION 
                       ", Copyright (C) 2004, 2005 Gerardo Garca Pea");
  _pdi_log(NULL, NULL, PACKAGE_NAME " comes with ABSOLUTELY NO WARRANTY; for details read the");
  _pdi_log(NULL, NULL, "`COPYING' file that comes with this library. This is free software,");
  _pdi_log(NULL, NULL, "and you are welcome to redistribute it under certain conditions;");
  _pdi_log(NULL, NULL, "read the `COPYING' file for details.");
  _pdi_log(NULL, NULL, "----------------------------------------------------------------------");

  _pdi_log(THIS, "pDI-Tools configuration have been loaded.");

  /* Initialize code that will identify and monitorize threads */
#if PDI_CALLBACKS_ENABLED
  if(_pdi_ebe_initGetThreadId())
  {
    _pdi_error(THIS, "Cannot initialize thread managing code.");
    exit(1);
  }
#endif

  /* Initializa arch dependant code */
  if(_pdi_arch_init())
  {
    _pdi_error(THIS, "Cannot initialize arch independant part of pDI-Tools.");
    exit(1);
  }

  /* Build mirror of the Runtime Linker object list */
  if(_pdi_ebe_initObjectList())
  {
    _pdi_error(THIS, "Error executing _pdi_ebe_initObjectList()");
    exit(1);
  }

  /* Initialize callback handling routines */
#if PDI_CALLBACKS_ENABLED
  if(_pdi_arch_initCallback())
  {
    _pdi_error(THIS, "Error initializing callback engine.");
    exit(1);
  }
#endif

  /* Now is a good moment to run a arch dependant code that will get */
  /* a set of real pointers to some functions used by pDI-Tools      */
  if(_pdi_arch_initSafeFuncs())
  {
    _pdi_error(THIS, "Error while executing _pdi_arch_initSafeFuncs().");
    exit(1);
  }

  /* Proceed to the load of interposition commands files combining */
  /* them in a final configuration called "FINAL_CONFIG"           */
  _pdi_log(THIS, "Processing interposition commands files.");
  if(!PDICFG.beconfig_files)
    _pdi_warning(THIS, "There is any interposition commands file.");

  if((becfg = _pdi_becfg_newConfig("FINAL_CONFIG")) == NULL)
  {
    _pdi_error(THIS, "Cannot build a final interposition command script.");
    exit(1);
  }

  /* While reading configuration files they are combined with the final conf */
  if(PDICFG.beconfig_files)
  {
    for(p = PDICFG.beconfig_files; *p; p++)
    {
      /* read a interposition commands file */
      _pdi_log(THIS, "  - Reading '%s'...", *p);
      if((tmpcfg = _pdi_becfg_loadBackendConfig(*p)) == NULL)
      {
        _pdi_log(THIS, "Error happened while processing '%s'.", *p);
        exit(1);
      }

      /* mix it with final config */
      _pdi_log(THIS, "  - Combining commands.");
      if(_pdi_becfg_mergeBackendConfigFiles(becfg, tmpcfg))
      {
        _pdi_error(THIS, "Something weird happened while combining config files.");
        exit(1);
      }

      /* free memory used by this interposition commands file */
      _pdi_becfg_destroyConfig(tmpcfg);
    }
    _pdi_log(THIS, "Processing of interposition commands files finalized correctly.");
  }

  /* Show objects and backends that will be used by this configuration */
  _pdi_becfg_showObjects(LOG_LEVEL_LOG, becfg);

  /* Check and apply this final configuration */
  _pdi_log(THIS, "Installing backends and interpositions.");
  if(_pdi_becfg_applyBackendConfig(becfg))
  {
    _pdi_error(THIS, "An error happened while applying interposition commands.");
    exit(1);
  }

  /* Free memory used by the super-final-config */
  _pdi_becfg_destroyConfig(becfg);

  _pdi_log(THIS, "pDI-Tools initialized succesfully!");
}

