/*****************************************************************************
 * $Id: fini.c,v 1.1 2005/08/02 10:50:15 killabyte Exp $
 *
 * This file contains pDI-Tools finalization code. This file makes calls to all
 * backends and pDI-Tools modules to free memory and close all files.
 *
 * Initialization code of pDI-Tools is contained in file 'init.c' in this
 * directory.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<pdiconfig.h>
#include<ebeif.h>
#include<log.h>

static void finiLiblink(void) __attribute__ ((destructor));

static void finiLiblink(void)
{
  _pdi_log(THIS, "Finalizing pDI-Tools.");

  /* Uninstall all code interpositions */
  if(_pdi_ebe_uninstallAllInterpositions())
  {
    _pdi_error(THIS, "An error happened while uninstalling interpositions.");
    exit(1);
  }

  /* Execute backends finalization code */
  _pdi_ebe_finalizeAllBackends();

  /* Unload all backends from memory */
#if !NO_DLCLOSE_AT_FINI
  if(_pdi_ebe_unloadAllBackends())
  {
    _pdi_error(THIS, "Something weird happened while unloading backends.");
    exit(1);
  }
#else
  _pdi_warning(THIS, "This version of pDI-Tools is configured to not close "
               "backends at execution finalization.");
#endif

  /* Finalize arch dependant part of pDI-Tools */
  if(_pdi_arch_fini())
  {
    _pdi_error(THIS, "No se pudo finalizar la parte dependiente de la arquitectura.");
    exit(1);
  }

  /* Finalize callback engine */
#if PDI_CALLBACKS_ENABLED
  _pdi_arch_finiCallback();
#endif

  /* Free memory used by the object list */
  _pdi_ebe_finiObjectList();

  /* Unload current configuration and write the FINAL MESSAGE */
  _pdi_log(THIS, "* pDI-Tools execution finalizes here *");
  _pdi_unloadConfiguration();
}

