/*****************************************************************************
 * $Id: threadid.h,v 1.1 2005/07/21 23:01:29 killabyte Exp $
 *
 * This file export data and functions to manage thread stacks. This stacks
 * will be used to store temporal information while executing callback
 * interpositions. This API also offers function to configure the "thread id
 * resolver" that will make pDI-Tools thread library independant.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_THREADID_H__
#define __PDI_THREADID_H__

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * void **_pdi_callback_stacks
 *   This is a pointer to a pointers table. Each entry of this table is NULL or
 *   points to a stack of 'PDICFG.cb_stack_size' size. If the parameter
 *   'PDICFG.max_threads' is zero '_pdi_callback_stacks' will be zero.
 *
 * void *pdi_callback_stack;
 *   A pointer to a stack for callbacks. When parameter 'max_threads' is 0 only
 *   one stack is used, so '_pdi_callback_stacks' is NULL and is used this
 *   variable global instead it.
 *
 * NOTE: We don't recommed to use these global variables from any other module.
 *
 *****************************************************************************/

void **_pdi_callback_stacks;
void *_pdi_callback_stack;

int (*_pdi_ebe_getThreadIdResolver(void))(void);
void _pdi_ebe_setThreadIdResolver(int (*thresolver)(void));
int _pdi_ebe_initGetThreadId(void);
void _pdi_ebe_finiGetThreadId(void);
void *_pdi_ebe_getThreadCallbackStack(int *p_thread_id);

#ifdef __cplusplus
}
#endif

#endif
