/*****************************************************************************
 * $Id: types.h,v 1.1 2005/07/23 09:59:48 killabyte Exp $
 *
 * This file defines platform dependant structures and data types used by this
 * Elf Backend.
 *
 *       NOTE: This file must not be included directly from any program. You
 *             must use this file through header file '/include/ebeif.h'
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_SOLARIS_TYPES_H__
#define __PDI_SOLARIS_TYPES_H__

#include<elf.h>
#include<link.h>
#include<libelf.h>

/*****************************************************************************
 * Check that this file have been included from '/include/ebeif.h'. If not we
 * will emit an error as big as a pine.
 *****************************************************************************/

#ifndef __PROCESSING_EBEIF_H__
#error "Don't use directly this file. Use instead <ebeif.h>"
#endif

/*****************************************************************************
 * MACROS
 *
 * ElfW(type)
 * ELFW(macro)
 *   These macros are used to simplify access to ELF structures and macros.
 *   Using this macros the programmer does not need to know if he is working in
 *   32 or 64 bits mode. For instance, if we write ElfW(Rela), the macro ElfW()
 *   will translate it to the type 'Elf32_Rela' or 'Elf64_Rela', according to
 *   the current platform.
 *
 * ELFW_R_SYM
 * ELFW_R_TYPE
 * ELFW_R_INFO
 *   Having 'ElfW()' and 'ELFW()' macros these macros does not seem too much
 *   necessary, but sometimes will make easier to read pDI-Tools code. For
 *   instance, take a look to this expression:
 *
 *     ELFW(R_SYM)(((ElfW(Rel) *) pos)->r_info)
 *
 *   If the programmer is a beginner probably will die when seeing that horror.
 *   With these macros we can write the same expression in a prettier way:
 *
 *     ELFW_R_SYM(((ElfW(Rel) *) pos)->r_info)
 *
 *   ...which is clearly clearer.
 *
 *****************************************************************************/

#if defined(_LP64)
# define PDI_SOLARIS_ELF_NATIVE_CLASS  64
#else
# define PDI_SOLARIS_ELF_NATIVE_CLASS  32
#endif

#ifndef ElfW
# define ElfW(type)      _ElfW (Elf, PDI_SOLARIS_ELF_NATIVE_CLASS, type)
# define _ElfW(e,w,t)    _ElfW_1 (e, w, _##t)
# define _ElfW_1(e,w,t)  e##w##t
#endif

#ifndef ELFW
# define ELFW(macro)     _ELFW (ELF, PDI_SOLARIS_ELF_NATIVE_CLASS, macro)
# define _ELFW(e,w,t)    _ELFW_1 (e, w, _##t)
# define _ELFW_1(e,w,t)  e##w##t
#endif

#define ELFW_R_SYM      ELFW(R_SYM)
#define ELFW_R_TYPE     ELFW(R_TYPE)
#define ELFW_R_INFO     ELFW(R_INFO)

/*****************************************************************************
 * Platform configuration
 *
 *   Choose data structures used by this system.
 *
 *****************************************************************************/

#define SOLARIS_PLTREL            ElfW(Rela)
#define SOLARIS_PLTREL_SZ         sizeof(ElfW(Rela))
#define SOLARIS_PLTREL_DT         DT_RELA
#define SOLARIS_R_JMPREL_TYPE     R_SPARC_JMP_SLOT
#define SOLARIS_R_JMPREL_TYPE_STR "R_SPARC_JMP_SLOT"

/*****************************************************************************
 * struct _tag_PDI_SOLARIS_ELFOBJ
 * struct _tag_PDI_SOLARIS_INTERCEPT
 *
 *   Architecture specific information for the structures PDI_ELFOBJ and
 *   PDI_INTERCEPT.
 *
 * PDI_ARCH_ELFOBJ
 * PDI_ARCH_INTERCEPT
 *   These two alias are for the structures PDI_IRIX_ELFOBJ and
 *   PDI_IRIX_INTERCEPT. Using this alias we can use this structures from
 *   platform independant code.
 *
 *****************************************************************************/

typedef struct _tag_PDI_SOLARIS_ELFOBJ {
  /* a pointer to the runtime linker data about this object */
  struct link_map  *lm;

  /* broken dso */
  /* There are some dynamic shared objects (for instance 'libdl.so',      */
  /* '/usr/platform/SUNW,Ultra-2/lib/sparcv9/libc_psr.so.1', ...) which   */
  /* are really ugly. In other words, the don't have obligatory sections, */
  /* its ELF structures are incomplete or incongruent, etc. So pDI-Tools  */
  /* tag them to avoid to try to process them accidentally.               */
  int              broken_dso;

  /* prefetched info */
  ElfW(Addr)       stringTable;
  ElfW(Word)       stringTableSize;
  ElfW(Addr)       symbolTable;
  ElfW(Word)       symbolSize;
  ElfW(Addr)       hashTable;
  ElfW(Addr)       gotTable;

  /* Relocation Tables */
  /* NOTE: In the future following will be useful for Solaris/x86 */
/*ElfW(Addr)       relTable;     */
/*ElfW(Word)       relTableSize; */
/*ElfW(Word)       relEntSize;   */
  ElfW(Addr)       relaTable;
  ElfW(Word)       relaTableSize;
  ElfW(Word)       relaEntSize;

  ElfW(Addr)       jmpRelTable;
  ElfW(Word)       jmpRelTableSize;
/* NOTE: If we support x86 in the future following could be useful */
/*ElfW(Word)       pltRel;        */
/*ElfW(Word)       pltRelEntSize; */

  /* hash info */
  unsigned int     n_bucket, n_chain,
                   *l_bucket, *l_chain;
} PDI_SOLARIS_ELFOBJ;

#if PDI_SOLARIS_ELF_NATIVE_CLASS == 32
#  define PDI_SOLARIS_RELINK_CODE_UNDO_SZ 8
#else
#  define PDI_SOLARIS_RELINK_CODE_UNDO_SZ 32
#endif

typedef struct _tag_PDI_SOLARIS_INTERCEPT_RELINK {
  ElfW(Addr)    plt_address;
  char          orig_code[PDI_SOLARIS_RELINK_CODE_UNDO_SZ];
} PDI_SOLARIS_INTERCEPT_RELINK;

typedef struct _tag_PDI_SOLARIS_INTERCEPT_REDEFINITION {
  void          *symbol_st_value;
} PDI_SOLARIS_INTERCEPT_REDEFINITION;

typedef struct _tag_PDI_SOLARIS_INTERCEPT {
  union {
    PDI_SOLARIS_INTERCEPT_RELINK       relink;
    PDI_SOLARIS_INTERCEPT_REDEFINITION redefinition;
  } u;
} PDI_SOLARIS_INTERCEPT;

typedef PDI_SOLARIS_ELFOBJ    PDI_ARCH_ELFOBJ;
typedef PDI_SOLARIS_INTERCEPT PDI_ARCH_INTERCEPT;

#endif
