/*****************************************************************************
 * $Id: exports.h,v 1.2 2005/07/22 23:14:52 killabyte Exp $
 *
 * This file exports all public platform dependant functions and variables.
 *
 *       NOTE: This file must not be included directly from any program. You
 *             must use this file through header file '/include/ebeif.h'
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_SOLARIS_EXPORTS_H__
#define __PDI_SOLARIS_EXPORTS_H__

/*****************************************************************************
 * Check that this file have been included from '/include/ebeif.h'. If not we
 * will emit an error as big as a pine.
 *****************************************************************************/

#ifndef __PROCESSING_EBEIF_H__
#error "Don't use directly this file. Use instead <ebeif.h>"
#endif

/*****************************************************************************
 * Global variables
 *
 *   Here are exported platform specific global variables that can be of
 *   interest to a programmer.
 *
 *****************************************************************************/

extern struct r_debug *_pdi_solaris_r_debug;

/*****************************************************************************
 * Function prototypes
 *
 *   Here are exported all public platform specific functions. There are two
 *   groups: obligatory functions (needed by pDI-Tools) and optional (offered
 *   by this backend, but not used (at least directly) by the platform
 *   independant code of pDI-Tools.
 *
 *****************************************************************************/

/* Expected functions by pDI-Tools */
int   _pdi_solaris_deactivateRedefinition(PDI_INTERCEPT *i, PDI_ELFOBJ *target);
int   _pdi_solaris_fini(void);
void  _pdi_solaris_finiObjectList(void);
void  _pdi_solaris_freeElfObj(PDI_ELFOBJ *eo, int objpool_index);
void  _pdi_solaris_freeInterposition(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int   _pdi_solaris_init(void);
int   _pdi_solaris_initObjectList(void);
int   _pdi_solaris_initSafeFuncs(void);
int   _pdi_solaris_newElfObj(PDI_ELFOBJ *eo, int objpool_index);
int   _pdi_solaris_newInterposition(PDI_ELFOBJ *eo, char *wname, PDI_INTERCEPT *i);
int   _pdi_solaris_redefine(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int   _pdi_solaris_refreshObjectList(void);
int   _pdi_solaris_relink(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
void *_pdi_solaris_resolveSymbol(char *name);
void *_pdi_solaris_resolveSymbolInObject(PDI_ELFOBJ *obj, char *name);
int   _pdi_solaris_symbolIsUsedOrReferenced(PDI_ELFOBJ *obj, char *name);
int   _pdi_solaris_undoRedefine(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int   _pdi_solaris_undoRelink(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);

/* Functions offered by this backend */
void _pdi_solaris_debug_checkSections(void);
int  _pdi_solaris_resolveDebugInfoStruct(void);

/*****************************************************************************
 * Alias for obligatory functions
 *
 *   pDI-Tools expects that all platform dependant functions that it uses begin
 *   by the prefix _pdi_arch_. But in the other hand we follow a convention
 *   where all functions exported by an elf backend must have the prefix
 *   _pdi_ARCH_, where ARCH is the name of the architecture for this elf
 *   backend.
 *
 *   For this reason we assign an alias to each function so pDI-Tools can call
 *   them using the generic prefix _pdi_arch_.
 *
 *****************************************************************************/

#define _pdi_arch_deactivateRedefinition   _pdi_solaris_deactivateRedefinition
#define _pdi_arch_fini                     _pdi_solaris_fini
#define _pdi_arch_finiObjectList           _pdi_solaris_finiObjectList
#define _pdi_arch_freeElfObj               _pdi_solaris_freeElfObj
#define _pdi_arch_freeInterposition        _pdi_solaris_freeInterposition
#define _pdi_arch_init                     _pdi_solaris_init
#define _pdi_arch_initObjectList           _pdi_solaris_initObjectList
#define _pdi_arch_initSafeFuncs            _pdi_solaris_initSafeFuncs
#define _pdi_arch_newElfObj                _pdi_solaris_newElfObj
#define _pdi_arch_newInterposition         _pdi_solaris_newInterposition
#define _pdi_arch_redefine                 _pdi_solaris_redefine
#define _pdi_arch_refreshObjectList        _pdi_solaris_refreshObjectList
#define _pdi_arch_relink                   _pdi_solaris_relink
#define _pdi_arch_resolveSymbol            _pdi_solaris_resolveSymbol
#define _pdi_arch_resolveSymbolInObject    _pdi_solaris_resolveSymbolInObject
#define _pdi_arch_symbolIsUsedOrReferenced _pdi_solaris_symbolIsUsedOrReferenced
#define _pdi_arch_undoRedefine             _pdi_solaris_undoRedefine
#define _pdi_arch_undoRelink               _pdi_solaris_undoRelink

#endif
