/*****************************************************************************
 * $Id: safefunc.h,v 1.1 2005/07/21 23:01:01 killabyte Exp $
 *
 * This module exports pointers to some functions of the C library. They can be
 * used to avoid interferences with redefinitions and other interpositions.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_SAFEFUNC_H__
#define __PDI_SAFEFUNC_H__

#ifdef __cplusplus
extern "C" {
#endif

#include<config.h>

/*****************************************************************************
 * Function pointers
 *****************************************************************************/

extern int (*_pdi_safe_fflush)(FILE *stream);
extern int (*_pdi_safe_fprintf)(FILE *stream, const char *format, ...);
extern int (*_pdi_safe_fputc)(int c, FILE *stream);
extern int (*_pdi_safe_fputs)(const char *s, FILE *stream);
extern int (*_pdi_safe_vfprintf)(FILE *stream, const char *format, va_list ap);

/*****************************************************************************
 * Function prototypes
 *****************************************************************************/

int _pdi_initSafeFuncs(void);

#ifdef __cplusplus
}
#endif

#endif
