/*****************************************************************************
 * $Id: log.h,v 1.1 2005/07/14 22:23:31 killabyte Exp $
 *
 * This header file exports functions used to print error, warnings, logs and
 * debug messages in an easy, uniform and nice way.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_LOG_H__
#define __PDI_LOG_H__

#ifdef __cplusplus
extern "C" {
#endif

#define LOG_LEVEL_ERROR      0
#define LOG_LEVEL_WARNING    1
#define LOG_LEVEL_LOG        2
#define LOG_LEVEL_DEBUG      3

#define THIS               (char *) __FILE__, (char *) __FUNCTION__

void _pdi_debug(char *file, char *function, char *format, ...);
void _pdi_log(char *file, char *function, char *format, ...);
void _pdi_log_level(int level, char *file, char *function, char *format, ...);
void _pdi_warning(char *file, char *function, char *format, ...);
void _pdi_error(char *file, char *function, char *format, ...);

#ifdef __cplusplus
}
#endif

#endif
