/*****************************************************************************
 * $Id: exports.h,v 1.1 2005/07/22 23:09:39 killabyte Exp $
 *
 * This file exports all public platform dependant functions and variables.
 *
 *       NOTE: This file must not be included directly from any program. You
 *             must use this file through header file '/include/ebeif.h'
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_LINUX_EXPORTS_H__
#define __PDI_LINUX_EXPORTS_H__

/*****************************************************************************
 * Check that this file have been included from '/include/ebeif.h'. If not we
 * will emit an error as big as a pine.
 *****************************************************************************/

#ifndef __PROCESSING_EBEIF_H__
#error "Don't use directly this file. Use instead <ebeif.h>"
#endif

/*****************************************************************************
 * Global variables
 *
 *   Here are exported platform specific global variables that can be of
 *   interest to a programmer.
 *
 *****************************************************************************/

/* Linux and its link-editor are strongly linked with GNU libc so we need */
/* to know its version to operate with the link-editor memory structs     */
extern unsigned int _pdi_linux_vlibc;


/*****************************************************************************
 * Function prototypes
 *
 *   Here are exported all public platform specific functions. There are two
 *   groups: obligatory functions (needed by pDI-Tools) and optional (offered
 *   by this backend, but not used (at least directly) by the platform
 *   independant code of pDI-Tools.
 *
 *****************************************************************************/

/* Expected functions by pDI-Tools */
int   _pdi_linux_callback(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int   _pdi_linux_deactivateRedefinition(PDI_INTERCEPT *i, PDI_ELFOBJ *target);
int   _pdi_linux_defaultMaxStubs(void);
int   _pdi_linux_fini(void);
void  _pdi_linux_finiCallback(void);
void  _pdi_linux_finiObjectList(void);
void  _pdi_linux_freeElfObj(PDI_ELFOBJ *eo, int objpool_index);
void  _pdi_linux_freeInterposition(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int   _pdi_linux_init(void);
int   _pdi_linux_initCallback(void);
int   _pdi_linux_initObjectList(void);
int   _pdi_linux_initSafeFuncs(void);
int   _pdi_linux_newElfObj(PDI_ELFOBJ *eo, int objpool_index);
int   _pdi_linux_newInterposition(PDI_ELFOBJ *eo, char *wname, PDI_INTERCEPT *i);
int   _pdi_linux_redefine(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int   _pdi_linux_refreshObjectList(void);
int   _pdi_linux_relink(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
void *_pdi_linux_resolveSymbol(char *name);
void *_pdi_linux_resolveSymbolInObject(PDI_ELFOBJ *obj, char *name);
int   _pdi_linux_symbolIsUsedOrReferenced(PDI_ELFOBJ *obj, char *name);
int   _pdi_linux_undoCallback(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int   _pdi_linux_undoRedefine(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int   _pdi_linux_undoRelink(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);

/* Functions offered by this backend */
void _pdi_linux_debug_checkSections(void);

/*****************************************************************************
 * Alias for obligatory functions
 *
 *   pDI-Tools expects that all platform dependant functions that it uses begin
 *   by the prefix _pdi_arch_. But in the other hand we follow a convention
 *   where all functions exported by an elf backend must have the prefix
 *   _pdi_ARCH_, where ARCH is the name of the architecture for this elf
 *   backend.
 *
 *   For this reason we assign an alias to each function so pDI-Tools can call
 *   them using the generic prefix _pdi_arch_.
 *
 *****************************************************************************/

#define _pdi_arch_callback                 _pdi_linux_callback
#define _pdi_arch_deactivateRedefinition   _pdi_linux_deactivateRedefinition
#define _pdi_arch_defaultMaxStubs          _pdi_linux_defaultMaxStubs
#define _pdi_arch_fini                     _pdi_linux_fini
#define _pdi_arch_finiCallback             _pdi_linux_finiCallback
#define _pdi_arch_finiObjectList           _pdi_linux_finiObjectList
#define _pdi_arch_freeElfObj               _pdi_linux_freeElfObj
#define _pdi_arch_freeInterposition        _pdi_linux_freeInterposition
#define _pdi_arch_init                     _pdi_linux_init
#define _pdi_arch_initCallback             _pdi_linux_initCallback
#define _pdi_arch_initObjectList           _pdi_linux_initObjectList
#define _pdi_arch_initSafeFuncs            _pdi_linux_initSafeFuncs
#define _pdi_arch_newElfObj                _pdi_linux_newElfObj
#define _pdi_arch_newInterposition         _pdi_linux_newInterposition
#define _pdi_arch_redefine                 _pdi_linux_redefine
#define _pdi_arch_refreshObjectList        _pdi_linux_refreshObjectList
#define _pdi_arch_relink                   _pdi_linux_relink
#define _pdi_arch_resolveSymbol            _pdi_linux_resolveSymbol
#define _pdi_arch_resolveSymbolInObject    _pdi_linux_resolveSymbolInObject
#define _pdi_arch_symbolIsUsedOrReferenced _pdi_linux_symbolIsUsedOrReferenced
#define _pdi_arch_undoCallback             _pdi_linux_undoCallback
#define _pdi_arch_undoRedefine             _pdi_linux_undoRedefine
#define _pdi_arch_undoRelink               _pdi_linux_undoRelink

#endif
