/*****************************************************************************
 * $Id: types.h,v 1.2 2005/07/23 09:58:50 killabyte Exp $
 *
 * This file defines platform dependant structures and data types used by this
 * Elf Backend.
 *
 *       NOTE: This file must not be included directly from any program. You
 *             must use this file through header file '/include/ebeif.h'
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_IRIX_TYPES_H__
#define __PDI_IRIX_TYPES_H__

#include<elf.h>
#include<objlist.h>

/*****************************************************************************
 * Check that this file have been included from '/include/ebeif.h'. If not we
 * will emit an error as big as a pine.
 *****************************************************************************/

#ifndef __PROCESSING_EBEIF_H__
#error "Don't use directly this file. Use instead <ebeif.h>"
#endif

/*****************************************************************************
 * This implementation is only for MIPS.
 *****************************************************************************/

#if (PLATFORM_ASM != PDI_ASM_MIPS)
#error "This pDI-Tools version for Irix only works on MIPS"
#endif

/*****************************************************************************
 * MACROS
 *
 * ElfW(type)
 * ELFW(macro)
 *   These macros are used to simplify access to ELF structures and macros.
 *   Using this macros the programmer does not need to know if he is working in
 *   32 or 64 bits mode. For instance, if we write ElfW(Rela), the macro ElfW()
 *   will translate it to the type 'Elf32_Rela' or 'Elf64_Rela', according to
 *   the current platform.
 *
 * ELFW_R_SYM
 * ELFW_R_TYPE
 * ELFW_R_INFO
 *   Having 'ElfW()' and 'ELFW()' macros these macros does not seem too much
 *   necessary, but sometimes will make easier to read pDI-Tools code. For
 *   instance, take a look to this expression:
 *
 *     ELFW(R_SYM)(((ElfW(Rel) *) pos)->r_info)
 *
 *   If the programmer is a beginner probably will die when seeing that horror.
 *   With these macros we can write the same expression in a prettier way:
 *
 *     ELFW_R_SYM(((ElfW(Rel) *) pos)->r_info)
 *
 *   ...which is clearly clearer.
 *
 *****************************************************************************/

#if (_MIPS_SZPTR == 64)
# define PDI_IRIX_WORDSIZE      64
#else
# define PDI_IRIX_WORDSIZE      32
#endif

#ifndef ElfW
# define ElfW(type)     _ElfW (Elf, PDI_IRIX_WORDSIZE, type)
# define _ElfW(e,w,t)   _ElfW_1 (e, w, _##t)
# define _ElfW_1(e,w,t) e##w##t
#endif

#ifndef ELFW
# define ELFW(macro)    _ELFW (ELF, PDI_IRIX_WORDSIZE, macro)
# define _ELFW(e,w,t)   _ELFW_1 (e, w, _##t)
# define _ELFW_1(e,w,t) e##w##t
#endif

#define ELFW_R_SYM      ELFW(R_SYM)
#define ELFW_R_TYPE     ELFW(R_TYPE)
#define ELFW_R_INFO     ELFW(R_INFO)

/*****************************************************************************
 * Import the runtime linker global variable '__rld_obj_head'. It has to be
 * declared here because Irix does not offer any header file that defines it.
 *****************************************************************************/

extern ElfW(Obj_Info) *__rld_obj_head;

/*****************************************************************************
 * Platform configuration
 *
 *   Choose data structures used by this system (Irix/MIPS).
 *
 *****************************************************************************/

#define IRIX_PLTREL     ElfW(Rel)

/*****************************************************************************
 * struct _tag_PDI_IRIX_ELFOBJ
 * struct _tag_PDI_IRIX_INTERCEPT
 *
 *   Architecture specific information for the structures PDI_ELFOBJ and
 *   PDI_INTERCEPT.
 *
 * PDI_ARCH_ELFOBJ
 * PDI_ARCH_INTERCEPT
 *   These two alias are for the structures PDI_IRIX_ELFOBJ and
 *   PDI_IRIX_INTERCEPT. Using this alias we can use this structures from
 *   platform independant code.
 *
 *****************************************************************************/

typedef struct _tag_PDI_IRIX_ELFOBJ {
  /* a pointer to the runtime linker data about this object */
  ElfW(Obj_Info)   *oi;

  /* delta offset */
  /* In principle objects should load in a fixed position indicated by     */
  /* 'oi->oi_orig_ehdr'. But it is not always possible, and then the value */
  /* of this pointer sometimes is false. This is important because in MIPS */
  /* all pointers are absolute and, like 'oi->oi_orig_ehdr', they are not  */
  /* fixed when this happens. Parameter 'delta' is the diference between   */
  /* the actual position of the object in memory (oi->oi_ehdr) and its     */
  /* original (supposed) ubication (oi->oi_orig_ehdr). This diference will */
  /* be used to fix pointers contained in ELF structures.                  */
  ElfW(Addr)       delta;

  /* broken dso */
  /* Sometimes I see dead people. And objects that doesn't follow ELF */
  /* standard too... so I will tag them so pDI-Tools can avoid them.  */
  int              broken_dso;

  /* prefetched info */
  ElfW(Addr)       stringTable;
  ElfW(Word)       stringTableSize;
  ElfW(Addr)       symbolTable;
  ElfW(Word)       symbolSize;
  ElfW(Addr)       hashTable;

  /* GOT */
  ElfW(Addr)       gotTable;
  ElfW(Addr)       gotSym;
  ElfW(Word)       localGotElems;

  /* hash info */
  unsigned int     n_bucket, n_chain,
                   *l_bucket, *l_chain;
} PDI_IRIX_ELFOBJ;

typedef struct _tag_PDI_IRIX_PLT_UNDO_DATA {
  void            *addr;
  void            **slot_addr;
} PDI_IRIX_PLT_UNDO_DATA;

typedef struct _tag_PDI_IRIX_INTERCEPT_RELINK {
  PDI_IRIX_PLT_UNDO_DATA undo_data;
} PDI_IRIX_INTERCEPT_RELINK;

typedef struct _tag_PDI_IRIX_INTERCEPT_REDEFINITION {
  void          *symbol_st_value;
} PDI_IRIX_INTERCEPT_REDEFINITION;

typedef struct _tag_PDI_IRIX_INTERCEPT {
  union {
    PDI_IRIX_INTERCEPT_RELINK       relink;
    PDI_IRIX_INTERCEPT_REDEFINITION redefinition;
  } u;
} PDI_IRIX_INTERCEPT;

typedef PDI_IRIX_ELFOBJ    PDI_ARCH_ELFOBJ;
typedef PDI_IRIX_INTERCEPT PDI_ARCH_INTERCEPT;

#endif
