/*****************************************************************************
 * $Id: elfops.h,v 1.1 2005/07/22 22:27:36 killabyte Exp $
 *
 * Specific Irix functions and macros to work with ELF structures in memory.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_IRIX_ELFOPS_H__
#define __PDI_IRIX_ELFOPS_H__

#include<ebeif.h>

/*****************************************************************************
 * MACROS
 *
 * PDI_JMPREL_ELEM(o,i)
 *   In the DSO specified by the structure PDI_IRIX_ELFOBJ 'o' this macro
 *   returns the ElfW(Rel) or ElfW(Rela) (depends on the architecture) in
 *   position 'i' in its DT_JMPREL section.
 *
 *   NOTE: The parameter 'o' is used several times in this macro, so it is not
 *         recommended to use a function when calling this macro.
 *
 * PDI_GET_SYMBOL_NAME(o,i)
 *   In the DSO specified by the structure PDI_IRIX_ELFOBJ 'o' this macro
 *   returns a pointer to a string in the DT_STRTAB section with the name of
 *   the symbol 'i' in DT_SYMTAB.
 *
 *   NOTE: Don't use function calls as parameters when calling this macro!!!
 *
 *****************************************************************************/

#define PDI_JMPREL_ELEM(o,i)       ((IRIX_PLTREL *)                       \
                                     (((char *) (o)->jmpRelTable) +       \
                                      ((i) * (o)->pltRelEntSize)))
#define PDI_GET_SYMBOL_NAME(o,i)   (((char *) (o)->stringTable) +         \
                                    ((ElfW(Sym) *)                        \
                                     ((char *) (o)->symbolTable +         \
                                      ((i) * (o)->symbolSize)))->st_name)

/*****************************************************************************
 * Function prototypes
 *****************************************************************************/

ElfW(Phdr) *_pdi_irix_findProgramHeader(ElfW(Obj_Info) *oi, ElfW(Word) type);
ElfW(Dyn) *_pdi_irix_getFirstDynEntry(ElfW(Obj_Info) *oi);

IRIX_PLTREL *_pdi_irix_getFunctionRel(PDI_IRIX_ELFOBJ *obj,
                                      unsigned int symndx);
ElfW(Sym) *_pdi_irix_getSymbolTableEntry(PDI_IRIX_ELFOBJ *obj, char *name,
                                         unsigned int *symndx);

int _pdi_irix_alterPlt(PDI_ELFOBJ *eo, unsigned int symndx, void *target,
                       PDI_IRIX_PLT_UNDO_DATA *undo_data);
void _pdi_irix_restorePlt(PDI_IRIX_PLT_UNDO_DATA *undo_data);


#endif
