/*****************************************************************************
 * $Id: ebeif.h.in,v 1.1 2005/07/21 22:58:38 killabyte Exp $
 *
 * Here are defined the functions of the Elf-Backend that are independent from
 * the architecture and operating system. They will be used by pDI-Tools to
 * achieve its objectives. This file includes also platform dependant
 * functions, information and data structures.
 *
 * The file 'ebeif.h' is specific for a platform and is generated by Autoconf
 * using the template 'ebeif.h.in'.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_EBEIF_H__
#define __PDI_EBEIF_H__

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * __PROCESSING_EBEIF_H__
 *
 *   The platform dependant header files 'include/{arch}/types.h' and
 *   'include/{arch}/exports.h' never will be included directly from other file
 *   than 'ebeif.h'. To guarantee this they detect if the constant
 *   __PROCESSING_EBEIF_H__ is defined or not and, if it is not defined, they
 *   should raise and #error. Because that this constant is defined now and
 *   undefined at the end of this file.
 *
 *****************************************************************************/

#define __PROCESSING_EBEIF_H__ 1

/*****************************************************************************
 * backend.h
 *
 *   Include definition of backend interfaces. They are a set of macros and
 *   function prototypes that stablish the aspect that should have any backend.
 *
 *****************************************************************************/

#include<backend.h>

/*****************************************************************************
 * linux/types.h
 *
 *   Include data structures specific for this platform: PDI_ARCH_ELFOBJ and
 *   PDI_ARCH_INTERCEPT, with any other type of data and/or structure needed
 *   for this platform.
 *
 *****************************************************************************/

#include<linux/types.h>

/*****************************************************************************
 * Constants and data types
 *
 *   Now is defined some constants and structures used by the platform
 *   independant part of pDI-Tools.
 *
 *   This platform independant data structures contains references to platform
 *   dependant data structures.
 *
 * PDI_ALIAS_LIBC
 * PDI_ALIAS_MAIN
 * PDI_ALIAS_PDI
 *   Alias assigned (automatically) to C library DSO, to the binary executable
 *   and to pDI-Tools DSO (libpdi.so).
 *
 * PDI_IT_RELINK
 * PDI_IT_REDEFINITION
 * PDI_IT_CALLBACK
 *   These constants enums the three ways to interpose code: relinks,
 *   redefinitions or with a callback mechanism.
 *
 * PDI_INTERCEPT (struct _tag_PDI_INTERCEPT)
 *   Structure with information about an interposition.
 *
 * PDI_ELFOBJ (struct _tag_PDI_ELFOBJ)
 *   Structure with info about a DSO in memory and a list with all
 *   interpositions installed on it.
 *
 *****************************************************************************/

#define PDI_ALIAS_LIBC          "LIBC"
#define PDI_ALIAS_MAIN          "MAIN"
#define PDI_ALIAS_PDI           "PDI"

#define PDI_IT_RELINK           1
#define PDI_IT_REDEFINITION     2
#define PDI_IT_CALLBACK         3

typedef struct _tag_PDI_INTERCEPT {
  /* No-dependant information about this interposition */
  int                      i_type;     /* type of interposition                   */
  char                     *i_symbol;  /* symbol affected                         */
  struct _tag_PDI_ELFOBJ   *i_backend; /* backend will receive this interposition */
  void                     *i_wrapper; /* backend's interposed function           */

  /* dependant data for this platform */
  PDI_ARCH_INTERCEPT       *i_arch;

  /* Previous and next interposition on this object */
  struct _tag_PDI_INTERCEPT *i_prev;
  struct _tag_PDI_INTERCEPT *i_next;

  /* If this is a redefinition it will be in the redefinitions list */
  struct _tag_PDI_INTERCEPT *i_rd_prev;
  struct _tag_PDI_INTERCEPT *i_rd_next;
} PDI_INTERCEPT;

typedef struct _tag_PDI_ELFOBJ {
  /* Information about object */
  /*   Here is included the path to the object and, if it has, its alias. */
  /*   There is also a flag that tells if this object is a backend o a    */
  /*   regular dynamic shared object (DSO)                                */
  char      *o_name;
  char      *o_alias;
  int       o_isBackend;

  /* backend info */
  /*   following data are pointers to functions that may be implemented by   */
  /*   this backend. There is also a mad flag that says if this backend have */
  /*   been initialized or not.                                              */
  int       o_beInitialized;
  int       (*o_beInit)(void);
  void      (*o_beFini)(void);
  long      (*o_beCallbackRequired)(char *);
  void      (*o_bePreEventCallback)(long, long, long, long, long);
  void      (*o_bePostEventCallback)(long, long, long);
  
  /* dl_handler */
  /*   only for backends loaded by pDI-Tools. Is a handler to load, unload */
  /*   and use an object using libdl.so interface (dlopen, dlclose, ...)   */
  void      *o_dl_handler;

  /* Code interpositions installed on this object */
  PDI_INTERCEPT *o_rules;

  /* platform dependant information */
  /*   The structure PDI_ARCH_ELFOBJ is defined by the platform dependant */
  /*   '/include/ARCH/types.h' header file and it contains information    */
  /*   specific for this platform about this object                       */
  PDI_ARCH_ELFOBJ *o_arch;

  /* These two fields link this structure in the list of working DSO's */
  struct _tag_PDI_ELFOBJ *o_prev;
  struct _tag_PDI_ELFOBJ *o_next;
} PDI_ELFOBJ;

/*****************************************************************************
 * Functions and global variables
 *
 *   Here is declared the platform independant API and the global vars that it
 *   offers.
 *
 * _pdi_objlist
 *   List of objects currently in memory (with extra information).
 *
 * _pdi_libcobj
 *   Pointer to the structure that describes the C library DSO.
 *
 * _pdi_mainobj
 *   Pointer to the main (executable) object.
 *
 * _pdi_pdiobj
 *   Pointer to pDI-Tools core DSO (libpdi.so).
 *
 *****************************************************************************/

/* first element of the object list, and objects LIBC, MAIN and PDI */
extern PDI_ELFOBJ *_pdi_objlist;
extern PDI_ELFOBJ *_pdi_libcobj;
extern PDI_ELFOBJ *_pdi_mainobj;
extern PDI_ELFOBJ *_pdi_pdiobj;

/* Backend loading and unloading */
void        _pdi_ebe_finalizeAllBackends(void);
PDI_ELFOBJ *_pdi_ebe_loadBackend(char *path);
int         _pdi_ebe_unloadAllBackends(void);
int         _pdi_ebe_unloadBackend(PDI_ELFOBJ *obj);

/* Backend and object manipulation */
void        _pdi_ebe_finiObjectList(void);
void        _pdi_ebe_freeElfObj(PDI_ELFOBJ *eo);
void       *_pdi_ebe_getBackendSymbol(PDI_ELFOBJ *backend, char *symbol);
char       *_pdi_ebe_getObjectName(PDI_ELFOBJ *obj);
int         _pdi_ebe_initObjectList(void);
char       *_pdi_ebe_mainFilename(void);
PDI_ELFOBJ *_pdi_ebe_newElfObj(PDI_ELFOBJ *next);
PDI_ELFOBJ *_pdi_ebe_searchObjectByPath(char *path);
PDI_ELFOBJ *_pdi_ebe_searchObjectByAlias(char *alias);
PDI_ELFOBJ *_pdi_ebe_searchObject(char *x);
int         _pdi_ebe_setObjectAlias(PDI_ELFOBJ *obj, char *alias);

/* Code interposition managing functions */
PDI_INTERCEPT *_pdi_ebe_searchInterposition(PDI_ELFOBJ *eo, char *func);
int _pdi_ebe_installInterposition(int type,
                                  PDI_ELFOBJ *eo, char *func,
                                  PDI_ELFOBJ *backend, char *wname);
int _pdi_ebe_uninstallInterposition(PDI_ELFOBJ *eo, PDI_INTERCEPT *i);
int _pdi_ebe_uninstallBackendInterpositions(PDI_ELFOBJ *backend);
int _pdi_ebe_uninstallInterpositions(PDI_ELFOBJ *eo);
int _pdi_ebe_uninstallAllInterpositions(void);
int _pdi_ebe_protectBackend(PDI_ELFOBJ *backend);

/*****************************************************************************
 * linux/exports.h
 *
 *   This file exports platform dependant functions and global variables that
 *   must be public.
 *
 *****************************************************************************/

#include<linux/exports.h>

/*****************************************************************************
 * Undef __PROCESSING_EBEIF_H__ constant
 *
 *   See note about __PROCESSING_EBEIF_H__ at the begining of this file.
 *
 *****************************************************************************/

#undef __PROCESSING_EBEIF_H__

#ifdef __cplusplus
}
#endif

#endif
