/*****************************************************************************
 * $Id: constants.h,v 1.1 2005/07/14 22:18:44 killabyte Exp $
 *
 * In this file we enum things like known types of CPU, nice types of machine
 * code, operating systems we like to run on and things like that.
 *
 * NOTE: In this enumerations we never use zero to avoid confusions because in
 *       the C preprocessor a constant not defined in constructions like #if
 *       has value zero.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_CONSTANTS_H__
#define __PDI_CONSTANTS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Known assembly types (it is not exactly the same as CPU model. For    */
/* instance, Itanium and Itanium 2 are two distinct CPU's but both speak */
/* IA-64 (if we extend the meaning of 'speak' to unexpected limits)      */
#define PDI_ASM_IA32    1
#define PDI_ASM_IA64    2
#define PDI_ASM_MIPS    3
#define PDI_ASM_PPC     4

/* Nice Operating Systems */
#define PDI_OS_LINUX    1
#define PDI_OS_IRIX     2
#define PDI_OS_SOLARIS  3

#ifdef __cplusplus
}
#endif

#endif
