/*****************************************************************************
 * $Id: config.h,v 1.1 2005/07/14 20:19:37 killabyte Exp $
 *
 * In this file are used in correct order the header files marked by the
 * configuration script of pDI-Tools. Are declared also some constants with
 * help of hints given by the configuration script.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_CONFIG_H__
#define __PDI_CONFIG_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include"autoconfig.h"
#endif

#include"constants.h"
#include"datadir.h"

/* Try to use the file 'limits.h' to get a definition of PAGESIZE. But it is */
/* possible that in some platforms it is not defined. In this case try to    */
/* resolve the problem elegantly looking for thousands of constants. In the  */
/* worst case the function getpagesize(2) will be used, and in the very very */
/* worst case assume a page size of 4kb with an error tolerance of 5% as     */
/* explained in the book "Teleconomicron" (1).                               */

/* NOTE (1): Old book written with blood on human skin that explains how to  */
/*           contact with deads with telephone lines over digital conections */
/*           RDSI, ATM and Frame Relay.                                      */

/* (This mess is inspired and partially copied from GNU getpagesize.h) */
#if HAVE_LIMITS_H
#  include <limits.h>
#endif

#ifndef PAGESIZE
#  ifdef _SC_PAGESIZE
#    define PAGESIZE sysconf(_SC_PAGESIZE)
#  else /* no _SC_PAGESIZE */
#    if HAVE_SYS_PARAM_H
#      include<sys/param.h>
#      ifdef EXEC_PAGESIZE
#        define PAGESIZE EXEC_PAGESIZE
#      else /* no EXEC_PAGESIZE */
#        ifdef NBPG
#          define PAGESIZE NBPG * CLSIZE
#          ifndef CLSIZE
#            define CLSIZE 1
#          endif /* no CLSIZE */
#        else /* no NBPG */
#          if PLATFORM_OS == PDI_OS_IRIX
#            if HAVE_GETPAGESIZE
#              define PAGESIZE getpagesize() /* punt totally */
#            else
#              warning "I will assume a page size of 4 Kb."
#              define PAGESIZE 4096
#            endif
#          else
#            ifdef NBPC
#              define PAGESIZE NBPC
#            endif /* no NBPC */
#          endif /* no PDI_OS_IRIX */
#        endif /* no NBPG */
#      endif /* no EXEC_PAGESIZE */
#    else /* no HAVE_SYS_PARAM_H */
#      if HAVE_GETPAGESIZE
#        define PAGESIZE getpagesize() /* punt totally */
#      else
#        warning "I will assume a page size of 4 Kb."
#        define PAGESIZE 4096
#      endif
#    endif /* no HAVE_SYS_PARAM_H */
#  endif /* no _SC_PAGESIZE */
#endif

/* To work with mprotect(2) we will need some header files */
#if HAVE_SYS_MMAN_H
#  include<sys/mman.h>
#endif

/* Now include the string library of C */
#if HAVE_STRING_H
#  include<string.h>
#else
#  if HAVE_STRINGS_H
#    include<string.h>
#  endif
#endif

/* The library 'dl' gives the functions dlopen, dlclose y dlsym */
/* used for backend manipulation                                */
#if HAVE_DLFCN_H
#  include<dlfcn.h>
#endif

/* 'unistd.h', 'stdlib.h' and 'stdio.h' are mandatory */
#include<stdlib.h>
#include<stdio.h>
#include<unistd.h>

/* stat(2) function is used, too */
#include<sys/stat.h>

/* Some functions as log functions (_pdi_debug, pdi_log, pdi_error ...) */
/* have a variable number of parameters so 'stdarg.h' will be needed    */
#include<stdarg.h>

/* Linux pDI-Tools versions are very tied to GNU libc. So they must check  */
/* what glibc version are using. With this header we can discover GNU libc */
/* version.                                                                */
#if HAVE_GNU_LIBC_VERSION_H
# include<gnu/libc-version.h>
#endif

#ifdef __cplusplus
}
#endif

#endif
