/*****************************************************************************
 * $Id: backend.h,v 1.2 2005/07/20 23:03:02 killabyte Exp $
 *
 * This file exports the backend interface. Any elegant backend should make a
 * nice effort and include this file.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __PDI_BACKEND_H__
#define __PDI_BACKEND_H__

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * PDI_STRINGIZE(x)
 *
 *   This macro converts parameter 'x' to a string, expanding all macros if
 *   necessary.
 *
 *****************************************************************************/

#ifndef PDI_STRINGIZE
#define PDI_STRINGIZE(x)                PDI_STRINGIZE_2(x)
#define PDI_STRINGIZE_2(x)              #x
#endif

/*****************************************************************************
 * PDI_BE_FUNC_INIT
 * PDI_BE_FUNC_FINI
 * PDI_BE_FUNC_PRE_CB
 * PDI_BE_FUNC_POST_CB
 * PDI_BE_FUNC_CB_REQ
 *   Special function names in backends.
 *
 * PDI_STR_BE_FUNC_INIT
 * PDI_STR_BE_FUNC_FINI
 * PDI_STR_BE_FUNC_PRE_CB
 * PDI_STR_BE_FUNC_POST_CB
 * PDI_STR_BE_FUNC_CB_REQ
 *   Names of backend functions converted to strings. They are sometimes useful
 *   to print errors.
 *
 *****************************************************************************/

#define PDI_BE_FUNC_INIT                di_init_backend
#define PDI_BE_FUNC_FINI                di_fini_backend
#define PDI_BE_FUNC_CB_REQ              di_callback_required
#define PDI_BE_FUNC_PRE_CB              di_pre_event_callback
#define PDI_BE_FUNC_POST_CB             di_post_event_callback

#define PDI_STR_BE_FUNC_INIT            PDI_STRINGIZE(PDI_BE_FUNC_INIT)
#define PDI_STR_BE_FUNC_FINI            PDI_STRINGIZE(PDI_BE_FUNC_FINI)
#define PDI_STR_BE_FUNC_CB_REQ          PDI_STRINGIZE(PDI_BE_FUNC_CB_REQ)
#define PDI_STR_BE_FUNC_PRE_CB          PDI_STRINGIZE(PDI_BE_FUNC_PRE_CB)
#define PDI_STR_BE_FUNC_POST_CB         PDI_STRINGIZE(PDI_BE_FUNC_POST_CB)

/*****************************************************************************
 * Function prototypes
 *****************************************************************************/

int  PDI_BE_FUNC_INIT(void);
void PDI_BE_FUNC_FINI(void);
int  PDI_BE_FUNC_CB_REQ(char *func_name);
void PDI_BE_FUNC_PRE_CB(int virtual_processor, int event_id, ...);
void PDI_BE_FUNC_POST_CB(int virtual_processor, int event_id, int retval);

#ifdef __cplusplus
}
#endif

#endif
