from Globals import DTMLFile, ImageFile
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from OFS.PropertyManager import PropertyManager
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo, getSecurityManager
from OFS.Folder import Folder
from OFS.SimpleItem import Item

from Products.TemporaryFolder.TemporaryFolder import MountedTemporaryFolder

class ProductName(Folder):    
    "Application ProductName"

    security = ClassSecurityInfo()
    
    __ac_roles__=('pax_webuser',
                  'Manager',
                  'Anonymous')


    meta_type = 'PAX - ProductName Application'
  
    manage_options = (
        (
        {'label':'Contents', 'action':'manage_main'},
        {'label':'View', 'action':'index_html'},
        ) +
        PropertyManager.manage_options +
        RoleManager.manage_options +
        Item.manage_options
    )


    security.declareProtected('Pax Use', 'index_html')   
    index_html = PageTemplateFile('template/index_html.pt', globals())
    
    def __init__(self, id, title):
        "initialise a new instance of ProductName Application"
        self.id = id
        self.title = title


    security.declareProtected('Pax Add ProductName', 'manage_editProductNameAction')
    def manage_editProductNameAction(self, RESPONSE=None):
        "Edit ProductName Application."
        self._p_changed = 1
        RESPONSE.redirect('manage_main')

        return


manage_addProductNameForm = DTMLFile('template/manage_addProductNameForm', globals())

def manage_addProductNameAction(self, id, title, visible, RESPONSE=None):
    "Add a ProductName Application to a folder."
    ob = ProductName(id, title)
    self._setObject(id, ob)

    ob.manage_addProperty('visible', visible, 'boolean')
    
    RESPONSE.redirect('manage_main')
