from Globals import DTMLFile, ImageFile
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from OFS.PropertyManager import PropertyManager
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo, getSecurityManager
from OFS.Folder import Folder
from OFS.SimpleItem import Item
#from mx.DateTime import *
from crypt import crypt
import time
import string

import utils

# Classe principale dell'applicazione

class UsersTool(Folder):    
    "Gestione utenti"

    security = ClassSecurityInfo()
    
    meta_type = 'User Manager Tool'
  
    manage_options = (
        (
        {'label':'Gestione Utenti', 'action':'manage_main'},
#        {'label':'Gestione Utenti', 'action':'manage_users'},        
        )
#        +
#        PropertyManager.manage_options +
#        RoleManager.manage_options +
#        Item.manage_options
    )

    #security.declareProtected('Pax Use', 'index_html')

    manage_main = PageTemplateFile('template/manage_users.pt', globals())
    manage_editUser = PageTemplateFile('template/manage_editUser.pt', globals())         

    def __init__(self, id):
        "initialise a new instance of Pratiche Application"    
        self.id = id
        return

    security.declareProtected('Pax Add Pratiche','getUsers')
    def getUsers(self, REQUEST=None, RESPONSE=None):
        "getUsers"
        strsql = "select * from utenti_abilitati_web order by nominativo"

        results=utils.runMappedQuery(self.getConnection(),strsql)

        return results


    security.declareProtected('Pax Add Pratiche','getUserName')
    def getUserName(self,REQUEST=None):
        "return the username from request or session"

        if not REQUEST.has_key('username'):
            if not REQUEST.has_key('SESSION'):
                raise 'Doh!'
            else:
                username = REQUEST.SESSION['username']
        else:
            username = REQUEST['username']

        return username
        
    security.declareProtected('Pax Add Pratiche','getUserInfo')
    def getUserInfo(self, REQUEST=None, RESPONSE=None):
        "getUserInfo"

        username=self.getUserName(REQUEST)
        strsql = "select * from utenti_abilitati_web where cod_fisc = '%s'" % (username)

        results=utils.runMappedQuery(self.getConnection(),strsql)

        if len(results)<=0:
            raise "Utente non trovato"

        return results[0]


    security.declareProtected('Pax Add Pratiche','manage_performEditUser')
    def manage_performEditUser(self, REQUEST=None, RESPONSE=None):
        "manage_performEditUser"


        if not REQUEST:
            return 1

        cf=self.getUserName(REQUEST)
       
        strsql = "delete from utentiapplicazioni where cf_utente = '%s' " % cf

        utils.runQuery(self.getConnection(),strsql)
        v={}
        m={}
       
        
        if REQUEST.has_key('visualizza'):
            v = REQUEST['visualizza']        
            for app in v:
                strsql = "insert into utentiapplicazioni values ('%s','%s','%s','%s')" % (cf,app, '1','')
                utils.runQuery(self.getConnection(),strsql)

        if REQUEST.has_key('modifica'):
            m = REQUEST['modifica']

            for app in m:
                if app in v:
                    strsql = "update utentiapplicazioni set modifica = '1' where cf_utente = '%s' and id_applicazione = '%s'" % (cf,app)
                else:
                    strsql = "insert into utentiapplicazioni values ('%s','%s','%s','%s')" % (cf,app, '','1')

                utils.runQuery(self.getConnection(),strsql)

        return self.manage_editUser(self, REQUEST, manage_tabs_errormsg="Utente modificato!")


    security.declareProtected('Pax Use', 'storeLogin')            
    def storeLogin(self, REQUEST):
        "legge i dati dell'utente connesso"


        session = REQUEST.SESSION

        username=self.getUserName(REQUEST)
        
        result=self.getUserInfo(REQUEST)
      
        session['nome'] = string.capwords(result['NOMINATIVO'])
        session['sesso'] = result['SESSO']
        session['email'] = result['E_MAIL']
        session['tipoanag'] = result['TIPO_ANAG']
        session['idanag'] = result['ID_ANAG']
        session['username'] = result['COD_FISC']        
 	

        # aggiungiamo il nick alla lista degli utenti connessi...
        tf = getattr(self, 'temp_folder')

        now = time.time()
        ts = int(now)
        
        ua = time.strftime('%c (%A)', time.localtime(now))
            
        session['ts'] = ts

        # se non esiste il file, lo creo al volo
        try:
            nickfile = getattr(tf, username)    
        except:
            tf.manage_addFile(username, title=ua, content_type='text/plain', file='')
            nickfile = getattr(tf, username)
            nickfile.manage_addProperty('ts', ts, 'int')
            return 1

        if ts < (getattr(nickfile,'ts') + 20*60): 
            return 0
        else:
            nickfile.manage_changeProperties( {'ts':ts, 'title':ua} )
        return 1

    security.declareProtected('Pax Add Pratiche','getPermissionsMap')
    def getPermissionsMap(self, REQUEST=None, RESPONSE=None):
        "Ritorna la mappa dei permessi, se specificata ritorna solo quella dell'applicazione richiesta"


        username=self.getUserName(REQUEST)
        
        strsql = "select a.id, a.nome ,  b.visualizza , b.modifica , b.cf_utente\n\
                  from applicazioni a left outer join utentiapplicazioni b on\n\
                  (a.id = b.id_applicazione and b.cf_utente = '%s')" % (username)


        permissionsmap=utils.runMappedQuery(self.getConnection(),strsql)

        return permissionsmap


    security.declareProtected('Pax Use', 'has_role')            
    def has_role(self, application, role, REQUEST=None ):
        "Controlla se un utente ha un determinato ruolo"


        username=self.getUserName(REQUEST)
        
        strsql = "select a.id, a.nome ,  b.visualizza , b.modifica , b.cf_utente\n\
                  from applicazioni a left outer join utentiapplicazioni b on\n\
                  (a.id = b.id_applicazione and b.cf_utente = '%s')   where a.id = '%s'" % (username,application)

        perms=utils.runMappedQuery(self.getConnection(),strsql)

        if len(perms) <= 0:
            raise 'Errore, applicazione inesistente'

        return perms[0][role] == '1'
                        

    security.declareProtected('Pax Use', 'checkUser')            
    def checkUser(self,REQUEST=None,esterno=None):
        "checkUser"

        session = REQUEST.SESSION

        username=self.getUserName(REQUEST)
        
        username = REQUEST['username']=username.upper()
        password = REQUEST['password']

        strsql = "select * from utenti_abilitati_web where cod_fisc='%s' " % (username)

        desc,values = utils.runQuery(self.getConnection() ,strsql)

        if len(values) == 0:  # utente nuovo!
            return 0

        # attenzione: crypt!!
        if not esterno:
            pc = crypt(password, 'ab')
        else:
            pc = password

        strsql = "select * from utenti where cf='%s' and newpassword='%s'" % (username, pc)
       
        desc,values = utils.runQuery(self.getConnection(),strsql)

        if len(values) > 0:       # un utente vecchio e la password valida

            session['tnick'] = username
            self.storeLogin(REQUEST)
            
        else:                      # un utente nuovo?
            strsql = "select * from utenti where cf='%s' " % (username)

            desc,values = utils.runQuery(self.getConnection(),strsql)
        
            if len(values) == 0:  # utente nuovo!
                strsql = "insert into utenti (cf, newpassword) values ('%s', '%s')" % (username, pc)
                utils.runQuery(self.getConnection(),strsql)
                
                session['tnick'] = username
                self.storeLogin(REQUEST)

                return 2 # primo login
            else:   # no, solo un impostore...
                return 0 #errore 

        return 1 # ok

    security.declareProtected('Pax Use', 'changePassword')            
    def changePassword(self, username, newpassword, confirmedpassword):
        "changePassword"

        if str(newpassword)==str(confirmedpassword) and len(str(newpassword))>0:

            try:
                cnx = getattr(self, 'dbcnx')
                if cnx: CNX__ = cnx()
            except:
                return "Immpossibile completare l'operazione sul database"

            newpassc = crypt(newpassword, 'ab')
            strsql = "update utenti set newpassword='%s' where cf='%s'" % (newpassc, username)
            items, results = CNX__.query(strsql)
            return 1

        else:
            return 0




def manage_addUsersTool(self, id, RESPONSE=None):
    "Add a Pratiche Application to a folder."
    ob = UserTool(id)
    self._setObject(id, ob)
    ob = self._getOb(id)
    
    # impostazione dei permessi
#    ob.manage_permission('Pax Use', ['Manager','pax_webuser',], 1)


    RESPONSE.redirect('manage_main')

