from Globals import DTMLFile
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from OFS.PropertyManager import PropertyManager
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo, getSecurityManager
from OFS.Folder import Folder
from OFS.SimpleItem import Item

from simplePax import simplePax
from zopeComm import zopeComm

# Classe principale dell'applicazione

class zopePax(Folder, simplePax):    
    "Folder dell'applicazione Pax lato Zope"
  
    security = ClassSecurityInfo()
    
    __ac_roles__=('pax_webuser',
                  'Manager',
                  'Anonymous')

    meta_type = 'Pax Application'
  
    manage_options = (
        (
        {'label':'Contents', 'action':'manage_main'},
        {'label':'View', 'action':'index_html'},
        ) +
        PropertyManager.manage_options +
        RoleManager.manage_options +
        Item.manage_options
    )

    security.declareProtected('Pax Use', 'index_html')
    index_html = PageTemplateFile('template/index.pt', globals())

    standard_html_header = DTMLFile('template/standard_html_header', globals())
    standard_html_footer = DTMLFile('template/standard_html_footer', globals())    

    Segnatura_dtd = DTMLFile('Segnatura.dtml', globals())



    def __init__(self, id):
        "initialise a new instance of zopePax Application"

        simplePax.__init__(self)

        self.id = id

        f = self
        
        f.manage_addFolder('template')
        f.manage_addUserFolder('acl_users')


    
    def manage_editPaxAction(self, RESPONSE=None):
        "Edit Pax Application."
        self._p_changed = 1
        RESPONSE.redirect('manage_main')

        return


    security.declareProtected('Pax Add zopeComm', 'addZopeCommAction')
    def addZopeCommAction(self, zopeComm_id, RESPONSE=None):
        "Aggiunta di una nuova comunicazione web"
        
        #usr = getSecurityManager().getUser().getUserName()
        
        self._setObject(zopeComm_id, zopeComm(zopeComm_id))

        RESPONSE.redirect('index_html')

        

manage_addPaxForm = DTMLFile('template/manage_addPaxForm', globals())

def manage_addPaxAction(self, id, RESPONSE=None):
    "Add a Pax Application to a folder."
    ob = zopePax(id)
    self._setObject(id, ob)
    ob = self._getOb(id)

    # impostazione dei permessi
    ob.manage_permission('Pax Use', ['Manager','pax_webuser',], 1)
    ob.manage_permission('Pax Add zopeComm', ['Manager','pax_webuser',], 1)


    RESPONSE.redirect('manage_main')
    

  
