#sql module

import sys
import psycopg
from mx.DateTime import *

class sqlmodule():

    def __init__(self, DSN):
        "initialise a new instance of sqlModule"

        self.DSN=DSN
        self.connection=None

    def connect(self, DSN=None):
        "restituisce una connessione valida al database"

        if DSN <> None:
            self.DSN=DSN
    
        try:
            connection = psycopg.connect(DSN)
        except StandardError, err:
            print "Errore di connessione: ", err
            return None

        self.connection = connection
        return self.getConnection()

    def getConnection(self):
        if self.checkConnection():
            return None
        
        return self.connection

    def getCursor(self):
        if self.checkConnection():
            return None
        
        return connection.cursor()

    def checkConnection(self):
        # if not connected connect!
        return 0

    def secureExecute(self, username, cursor, sqlString, param, log=None):
        if self.checkConnection():
            return None

        sqlString = sqlString % param 
        
        result = cursor.execute(sqlString)

        if log:
            cursor.execute("INSERT INTO log VALUES (%s, %s, %s)", (username, now().strftime("%d/%m/%Y"), sqlString)) 

        return result
        

        
    
