import os
import xml.dom.minidom
from StringIO import StringIO
import sha
import time
import psycopg

# achtung!!
#import protocollo

 
# Comunicazione generica
class simpleComm:
    "Comunicazione generica"

    def __init__(self, schema=None):
        "initialise a new instance of simpleComm"

        # se inizializzata con uno schema...
        if schema:
            self.setSchema(schema)
        else:
            self.setSchema(self.commercio())

        self.__cursors = getCursor()
        


    def dummy(self):
        "dummy function"

        greetings = "Hi, I'm the simpleComm instance!"

        return greetings
    


    def setSchema(self, s, extAppl='composeForm'):
        "impostazione dello schema"

        self.__schema = s
        self.__extAppl = extAppl

        # dati per la segnatura
        self.__CodiceAmministrazione = "riva"
        self.__CodiceAOO = "comriva"
        self.__IndirizzoTelematicoOrigine = "web@comune.rivadelgarda.tn.it"

        return 

    

    def getSchema(self):
        "restituisce lo schema"

        return self.__schema


    def getExtAppl(self, pars=None):
        "restituisce l\'url dell\'applicazione che generer il form"

        if pars == None:
            pars = {}
            
        url = "./"
        for i in self.aq_parent.getListExtAppls():
            if self.__extAppl == i['id']:
                url = i['url']
                plist = ""
                for p in str(i.get('snd', '')).split(' '):
                    plist += "&%s=%s" % (p, pars.get(p, ''))
                if plist != "":
                    url += "?%s" % plist

        pathinfo = pars.get('URL', '/')
        ref = pathinfo[:pathinfo.rfind('/')] + '/actionForm'
        url += "&ref=%s" % ref
        
        return url
    
    

    def getExtApplId(self):
        "Restituisce l'id dell'applicazione esterna"

        return self.__extAppl
    
        
    def getUserName(self):
        "restituisce un nome stupido"

        return "I'm a dummy user..."
    
    
    def storeValue(self, diz, REQUEST):
        "inserisce nel database"

        # recupreo un protocollo
        c = self.getCursor()
        u = self.getUser(REQUEST)
        
        np, anno = self.getProtocolNumber(c, u)

        # utilizzo l'interoperabilita (futuro...)

        
        # protocollazione
        d = {}
        d['Anno'] = anno
        d['NumeroRegistrazione'] = np
        d['CodiceAmministrazione'] = self.codiceAmministrazione
        d['CodiceAOO'] = self.codiceAOO
        d['Oggetto'] = diz.get('oggetto', 'senza oggetto')
        d['UtenteInserimento'] = u
        d['Messaggio'] = diz.get('testo', 'senza testo' )
        d['Impronta'] = '' # quando servira'...
        d['URISegnatura'] = ''
        self.storeProtocol(c, u, d)
        
        return np
    


    def makeXML(self, diz, np):
        "genera la segnatura XML"

        DOM = xml.dom.minidom.Document()
        
        # <!ELEMENT Segnatura (Intestazione, Riferimenti?, Descrizione?)>
        # <!ATTLIST Segnatura
	#         versione NMTOKEN #FIXED "%dataPubblicazione;"
	#         xml:lang NMTOKEN #FIXED "it"
        # >
        SegnaturaElement = DOM.createElement("Segnatura")
        SegnaturaElement.setAttribute("versione", "2000-10-18")
        SegnaturaElement.setAttribute("lang", "it")
        DOM.appendChild(SegnaturaElement)

        # <!ELEMENT Intestazione (Identificatore, PrimaRegistrazione?, OraRegistrazione?,
        #                         Origine, Destinazione+, PerConoscenza*, Risposta?, Riservato?,
        #                         InterventoOperatore?, RiferimentoDocumentiCartacei?, Oggetto,
        #                         Classifica*, Note?)>
        IntestazioneElement = DOM.createElement("Intestazione")
        SegnaturaElement.appendChild(IntestazioneElement)

        # <!ELEMENT Identificatore (CodiceAmministrazione, CodiceAOO, NumeroRegistrazione, DataRegistrazione)>
        IdentificatoreElement = DOM.createElement("Identificatore")
        IntestazioneElement.appendChild(IdentificatoreElement)

        # <!ELEMENT CodiceAmministrazione (#PCDATA)>
        CodiceAmministrazioneElement = DOM.createElement("CodiceAmministrazione")
        IdentificatoreElement.appendChild(CodiceAmministrazioneElement)
        CodiceAmministrazioneText = DOM.createTextNode(self.__CodiceAmministrazione)
        CodiceAmministrazioneElement.appendChild(CodiceAmministrazioneText)

        # <!ELEMENT CodiceAOO (#PCDATA)>
        CodiceAOOElement = DOM.createElement("CodiceAOO")
        IdentificatoreElement.appendChild(CodiceAOOElement)
        CodiceAOOText = DOM.createTextNode(self.__CodiceAOO)
        CodiceAOOElement.appendChild(CodiceAOOText)

        # <!ELEMENT NumeroRegistrazione (#PCDATA)>
        NumeroRegistrazioneElement = DOM.createElement("NumeroRegistrazione")
        IdentificatoreElement.appendChild(NumeroRegistrazioneElement)
        NumeroRegistrazioneText = DOM.createTextNode(str(np))
        NumeroRegistrazioneElement.appendChild(NumeroRegistrazioneText)
        
        # <!ELEMENT DataRegistrazione (#PCDATA)>
        now = time.localtime(time.time())
        DataRegistrazione = time.strftime("%Y-%m-%d" , now)
        DataRegistrazioneElement = DOM.createElement("DataRegistrazione")
        IdentificatoreElement.appendChild(DataRegistrazioneElement)
        DataRegistrazioneText = DOM.createTextNode(DataRegistrazione)
        DataRegistrazioneElement.appendChild(DataRegistrazioneText)

        # <!ELEMENT Origine (IndirizzoTelematico, Mittente)>
        OrigineElement = DOM.createElement("Origine")
        IntestazioneElement.appendChild(OrigineElement)

        # <!ELEMENT IndirizzoTelematico (#PCDATA)>
        # <!ATTLIST IndirizzoTelematico
	#         tipo (smtp | url | CDATA) "smtp"
	#         note CDATA #IMPLIED
        # >
        IndirizzoTelematicoElement = DOM.createElement("IndirizzoTelematico")
        OrigineElement.appendChild(IndirizzoTelematicoElement)
        IndirizzoTelematicoText = DOM.createTextNode(self.__IndirizzoTelematicoOrigine)
        IndirizzoTelematicoElement.setAttribute("tipo", "smtp")
        IndirizzoTelematicoElement.appendChild(IndirizzoTelematicoText)

        # <!ELEMENT Mittente (Amministrazione, AOO)>
        MittenteElement = DOM.createElement("Mittente")
        OrigineElement.appendChild(MittenteElement)

        # <!ELEMENT Amministrazione (Denominazione, CodiceAmministrazione?,
        #  (UnitaOrganizzativa | (Persona*, IndirizzoPostale, IndirizzoTelematico*, Telefono*, Fax*)))?>
        AmministrazioneElement = DOM.createElement("Amministrazione")
        MittenteElement.appendChild(AmministrazioneElement)

        # <!ELEMENT Denominazione (#PCDATA)>
        DenominazioneElement = DOM.createElement("Denominazione")
        AmministrazioneElement.appendChild(DenominazioneElement)
        DenominazioneText = DOM.createTextNode('denominazionemittente') # da parametrizzare
        DenominazioneElement.appendChild(DenominazioneText)

        # <!ELEMENT AOO (Denominazione, CodiceAOO?)>
        AOOElement = DOM.createElement("AOO")
        MittenteElement.appendChild(AOOElement)

        # <!ELEMENT Denominazione (#PCDATA)>
        DenominazioneElement = DOM.createElement("Denominazione")
        AOOElement.appendChild(DenominazioneElement)
        DenominazioneText = DOM.createTextNode('denominazionemittenteaoo') # da parametrizzare
        DenominazioneElement.appendChild(DenominazioneText)

        # <!ELEMENT Destinazione (IndirizzoTelematico, Destinatario*)>
        # <!ATTLIST Destinazione
	#         confermaRicezione (si | no) "no"
        # >
        DestinazioneElement = DOM.createElement("Destinazione")
        DestinazioneElement.setAttribute("confermaRicezione", "no")
        IntestazioneElement.appendChild(DestinazioneElement)

        # <!ELEMENT IndirizzoTelematico (#PCDATA)>
        # <!ATTLIST IndirizzoTelematico
	#         tipo (smtp | url | CDATA) "smtp"
	#         note CDATA #IMPLIED
        # >
        IndirizzoTelematicoElement = DOM.createElement("IndirizzoTelematico")
        DestinazioneElement.appendChild(IndirizzoTelematicoElement)
        IndirizzoTelematicoText = DOM.createTextNode('indirizzotelematicodestinazione')
        IndirizzoTelematicoElement.setAttribute("tipo", "smtp")
        IndirizzoTelematicoElement.appendChild(IndirizzoTelematicoText)        

        # <!ELEMENT Oggetto (#PCDATA)>
        OggettoElement = DOM.createElement("Oggetto")
        IntestazioneElement.appendChild(OggettoElement)
        OggettoText = DOM.createTextNode(diz.get('oggetto', 'nessuno'))
        OggettoElement.appendChild(OggettoText)

        # <!ELEMENT Descrizione ((Documento | TestoDelMessaggio), Allegati?, Note?)>
        DescrizioneElement = DOM.createElement("Descrizione")
        SegnaturaElement.appendChild(DescrizioneElement)
        TestoDelMessaggioText = DOM.createTextNode(diz.get('testo', 'nessuno'))
        DescrizioneElement.appendChild(TestoDelMessaggioText)
        
        # questo  il metodo per aggirare il fatto che Document.toxml non scrive l'encoding
        writer = StringIO()
        writer.write('<?xml version="1.0" encoding="UTF-8" ?>\n')
        for node in DOM.childNodes:
            node.writexml(writer, "", "\t", "\n")
        xmlout = writer.getvalue()
        
        return xmlout


    
    
    # metodi di test...

    def commercio(self):
        "test di struttura per il commercio"

        desc = [{'nums':1,
                 'text':'Oggetto:',
                 'ctrls':({'control':'text',
                           'label':'Oggetto:',
                           'name':'oggetto',
                           'type':'string',
                           'extra':'size=50',
                           'value':'',},
                          ),
                 },
                {'nums':1,
                 'text':'Testo:',
                 'ctrls':({'control':'textarea',
                           'label':'Testo:',
                           'name':'testo',
                           'type':'string',
                           'extra':'size=50',
                           'value':'',},
                          ),
                 },]
                
        
        return desc



    
