from Globals import DTMLFile
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from OFS.PropertyManager import PropertyManager
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo, getSecurityManager
from OFS.Folder import Folder
from OFS.SimpleItem import Item
from zopeComm import zopeComm

from mx.DateTime import *
import psycopg
from ipax import ipax
import os

# Classe principale dell'applicazione

class pax(Folder):    
    "Folder dell'applicazione Pax lato Zope"
  
    security = ClassSecurityInfo()
    
    __ac_roles__=('pax_webuser',
                  'Manager',
                  'Anonymous')

    meta_type = 'Pax Application'
  
    manage_options = (
        (
        {'label':'Contents', 'action':'manage_main'},
        {'label':'View', 'action':'index_html'},
        {'label':'Config', 'action':'manage_config'},
        {'label':'External applications', 'action':'manage_extappl'},
        ) +
        PropertyManager.manage_options +
        RoleManager.manage_options +
        Item.manage_options
    )

    security.declareProtected('Pax Use', 'index_html')
    index_html = PageTemplateFile('template/index.pt', globals())

    manage_extappl = PageTemplateFile('template/manage_extappl.pt', globals())
    manage_config = PageTemplateFile('template/manage_config.pt', globals())

    standard_html_header = DTMLFile('template/standard_html_header', globals())
    standard_html_footer = DTMLFile('template/standard_html_footer', globals())    
    pax_css = DTMLFile('template/pax.css', globals())

    Segnatura_dtd = DTMLFile('Segnatura.dtml', globals())

    def __init__(self, id):
        "initialise a new instance of zopePax Application"

        self.id = id
        
        self.manage_addFolder('template')
        self.manage_addUserFolder('acl_users')

        DSN='host=localhost\
        dbname=pratiche\
        user=postgres'

        self.DSN = DSN
        self._v_connection = None

        self.__extAppls = [
            {'id':'default', 'descr':'Form descritto in schema', 'url':'composeForm'},
            ]

        self.codiceAmministrazione = 'none'
        self.codiceAOO = 'none'
        self.indirizzoTelematico = 'none'
        
        if self.connectDB() == None:
            raise "cannot connect the DB"
            exit
            

    def getAmmAttr(self):
        "restituisce un dizionario con gli attributi di PAX"

        d = {'codiceAmministrazione':self.codiceAmministrazione,
             'codiceAOO':self.codiceAOO ,
             'indirizzoTelematico':self.indirizzoTelematico}
        
        return d

    def getNumeroRegistrazione(self,cursor, username):
        "Ritorna un nuovo numero univoco dalla tabella del protocollo"

        sqlString = "INSERT INTO protocolli (Numeroregistrazione, utenteinserimento, dataregistrazione, anno)\
        SELECT ltrim(to_char (coalesce(max(to_number(Numeroregistrazione, '9999999')), 0) + 1 , '0000000' )), \
        %s, %s , %s from protocolli where anno=%s"

        params = (username, now().strftime("%d/%m/%Y"), now().strftime("%Y"), now().strftime("%Y"))
        
        self.secureExecuteDB(cursor, username,  sqlString, params, 1) # Create a new id


        sqlString = "SELECT MAX(numeroregistrazione) from protocolli where anno=%s and utenteinserimento = %s"

        params = ( now().strftime("%Y"),username)

        self.secureExecuteDB(cursor,username,  sqlString, params) # Get new id

        print sqlString % params

        results = cursor.fetchone()

        return (results[0], now().strftime("%Y")) #return the new of protocollo

    

    def storeProtocollo(self, cursor, username, params):
        "Salva i dati del protocollo"

        params.setdefault('Note','')
        params.setdefault('Riservato','')
        params.setdefault('RiferimentoDocumentiCartacei','')
        params.setdefault('Anno',now().strftime("%Y"))

        Messaggio = params['Messaggio']
        if len(params['Messaggio'])>=249:
            params['Messaggio']='vedere allegato'

        sqlString = "UPDATE protocolli SET codiceamministrazione=%(CodiceAmministrazione)s,  oggetto=%(Oggetto)s, codiceaoo=%(CodiceAOO)s,  note=%(Note)s, riservato=%(Riservato)s, riferimentodocumenticartacei=%(RiferimentoDocumentiCartacei)s, messaggio=%(Messaggio)s, impronta=%(Impronta)s, urisegnatura=%(URISegnatura)s where anno=%(Anno)s and NumeroRegistrazione = %(NumeroRegistrazione)s"


#        raise Messaggio
        Messaggio=Messaggio.replace('|','\r\n')
    
        d=[('-P',params['NumeroRegistrazione'] ),
           ('-A', params['CodiceAmministrazione']),
           ('-O', params['CodiceAOO']),
           ('-I', 'esercente@esercizio.it'),
           ('-M', 'utente web'),
           ('-D', 'commercio@comune.rivadelgarda.tn.it'),
           ('-o', params['Oggetto']),
           ('-t', Messaggio),
           ('-s', 'localhost')]


        oldpath=os.environ['PWD']
        os.chdir('/var/www/protocolli')
        ipax(d,"i")
        os.chdir(oldpath)
        
        self.secureExecuteDB(cursor, username,  sqlString, params, 1)


    def connectDB(self, DSN=None):
        "restituisce una connessione valida al database"
      
        if DSN:
            self.DSN=DSN
   
        try:
            connection = psycopg.connect(self.DSN)
        except StandardError, err:
            raise "Errore di connessione: ", err
            return None
        
        self._v_connection = connection
        
        return self.getConnectionDB()

    def getConnectionDB(self):
        "return the DB connection"
        if not self.checkConnectionDB():
            return None
        
        return self._v_connection

    def getCursorDB(self):
        "return a new cursor"
        if not self.checkConnectionDB():
            return None

        if not self._v_connection:
            raise "qualcosa e' andato storto"
        return  self._v_connection.cursor()

    def checkConnectionDB(self):
        "check the connection DB if it's closed reopen it"
        # if not connected connect!
        if not hasattr(self, '_v_connection'):
            self.connectDB()
            
        return 1

    def secureExecuteDB(self, cursor,username, sqlString, params, log=None):
        "exec a sqlstring fliing it with params and eventually logs it"
        if not self.checkConnectionDB():
            return None

        logSqlString = sqlString % params

        if log:
            try:
                cursor.execute("INSERT INTO log VALUES (%s, %s, %s)", (username, now().strftime("%d/%m/%Y %H:%M"), logSqlString)) 
            except StandardError, err:
                raise "Errore nell'inserimento nella tabella di log" ,err      
    
        try:
            result = cursor.execute(sqlString , params)
        except StandardError, err:
            raise "Errore nell'esecuzione di ", err      

        self._v_connection.commit()
        
        return result 




    def getListExtAppls(self):
        "restituisce un dizionario con gli url delle applicazioni esterne"

        return self.__extAppls




    def manage_saveConfig(self, REQUEST, RESPONSE=None):
        "configura pax"

        self.codiceAmministrazione = REQUEST.get('codiceAmministrazione', '')
        self.codiceAOO = REQUEST.get('codiceAOO', '')
        self.indirizzoTelematico = REQUEST.get('indirizzoTelematico', '')

        self._p_changed = 1

        return self.manage_config(self, REQUEST, manage_tabs_message="Modified!")
    


    def manage_editExtAppls(self, REQUEST, RESPONSE=None):
        "cambia le propriet relative alle applicazioni esterne"

        id_list = REQUEST.get('id', [])
        descr_list = REQUEST.get('descr', [])
        url_list = REQUEST.get('url', [])
        snd_list = REQUEST.get('snd', [])
        rcv_list = REQUEST.get('rcv', [])
        
        new_list = []
        
        for i in range(0,len(id_list)):
            if i == 0:
                new_list.append({'id':id_list[i],
                                 'descr':descr_list[i],
                                 'url':url_list[i]})
            else:
                new_list.append({'id':id_list[i],
                                 'descr':descr_list[i],
                                 'snd':snd_list[i-1],
                                 'rcv':rcv_list[i-1],
                                 'url':url_list[i]})
                

        self.__extAppls = new_list
        self._p_changed = 1

        return self.manage_extappl(self, REQUEST, manage_tabs_message="Modified!")
    


    def manage_delExtAppls(self, ids=None, REQUEST=None, RESPONSE=None):
        "cancella le configurazioni per le applicazioni esterne selezionate"

        ids = REQUEST.get('_ids', ids)

        for i in ids:
            for d in self.__extAppls:
                if d['id'] == i:
                    self.__extAppls.remove(d)

        self._p_changed = 1

        return self.manage_extappl(self, REQUEST, manage_tabs_message="Deleted!")


    def manage_addExtAppl(self, REQUEST, RESPONSE=None):
        "aggiunge una nuova applicazione esterna"

        if REQUEST.has_key('id'):
            idapp = REQUEST['id']
            app = {'id':idapp,
                   'descr':REQUEST['descr'],
                   'snd':REQUEST['snd'],
                   'rcv':REQUEST['rcv'],
                   'url':REQUEST['url']}

            np = 1
            for i in self.__extAppls:
                if i['id'] == idapp:
                    np = 0

            if np:
                self.__extAppls.append(app)
                self._p_changed = 1

        return self.manage_extappl(self, REQUEST, manage_tabs_message="Added!")
        

    
    security.declareProtected('Pax Add zopeComm', 'addZopeCommAction')
    def addZopeCommAction(self, zopeComm_id, RESPONSE=None):
        "Aggiunta di una nuova comunicazione web"
        
        #usr = getSecurityManager().getUser().getUserName()
        
        self._setObject(zopeComm_id, zopeComm(zopeComm_id))

        RESPONSE.redirect('index_html')


manage_addPaxForm = DTMLFile('template/manage_addPaxForm', globals())

def manage_addPaxAction(self, id, RESPONSE=None):
    "Add a Pax Application to a folder."
    ob = pax(id)
    self._setObject(id, ob)
    ob = self._getOb(id)

    # impostazione dei permessi
    ob.manage_permission('Pax Use', ['Manager','pax_webuser',], 1)
    ob.manage_permission('Pax Add zopeComm', ['Manager','pax_webuser',], 1)


    RESPONSE.redirect('manage_main')
