#!/usr/bin/env python
##############################################################################
#
# Copyright (c) AXIA Studio 2003. All Rights Reserved.
#
# info@axiastudio.it
#
##############################################################################

"""
Utility iPAX

  Utility di interoperabilita protocollo a riga di comando

"""

import os
import os.path
import sys
import getopt
from StringIO import StringIO
import time

import xml.dom.minidom
import sha
import MimeWriter
import mimetools
import multifile
import smtplib
import base64


def usage():
    print """

    usage: ipax [i|c|r] <opzioni>

    [i|c|r] : per le funzioni di invio, conferma, ricezione
    
    Argomenti obbligatori:

      -P (--protocollo) numero : numero di protocollo (7 decimali, giustificato mediante zeri)
      -A (--amministrazione) codamm : codice Amministrazione
      -O (--areaomogenea) codaoo : codice Area Organizzativa Omogenea
      -I (--indirizzoorigine) indirizzo : indirizzo telematico origine
      -D (--indirizzodestinazione) indirizzo : indirizzo telematico destinazione
      -s (--smtp) urlserver : server SMTP da utilizzare per l'invio


    Argomenti obbligatori invio:
    
      -M (--mittente) mittente : denominazione del mittente nella AOO
      -o (--oggetto) oggetto : oggetto del protocollo


    Argomenti obbligatori conferma:

      -m (--messaggio) messaggio : conferma di messaggi non protocollati
    

    Argomenti opzionali:

      -T (--data) data: data protocollo (ISO 8601 esteso, i.e. aaaa-mm-gg, per default la data odierna)
      --orareg ora : ora di registrazione (ISO 8601 esteso, i.e. hh:mm:ss[,ddd], "ora" per l'ora corrente)
      --confric si|no: conferma ricezione (di default "no")
      
      --tipoorigine (smpt|url|CDATA, default smtp) : tipo di indirizzo telematico origine
      --noteorigine (note, opzionale) : note indirizzo telematico origine

      -m (--messaggio) messaggio : se presente e' l'oggetto Documento
      -t (--txt) messaggio: come -m, ma messaggio come file di testo allegato
      -a (--attach) allegato1[,allegato2,...] : allegati separati da virgola (se manca -m, il primo allegato e' Documento)
      -r (--riferimenti) riferimento1[,riferimento2] : separati da virgola (MIME|informatico|cartaceo, default MIME)
      -e (--tipimime) tipo1[,tipo2,...] : tipi MIME separati da virgola (per default dalle estensioni di -a) 


    Esempi:

      ipax i -P 0000001 -A RIVATNCO -O WEBRIVA -I web@comune.rivadelgarda.tn.it -M "responsabile acquisti"\\
        -D pax@axiastudio.it -T 2003-12-16 -o prova -m "ecco fatto!" -s localhost --orareg 17:33:00

      ipax i -P 0000002 -A RIVATNCO -O WEBRIVA -I web@comune.rivadelgarda.tn.it -M "responsabile acquisti"\\
        -D pax@axiastudio.it -T 2003-12-16 -o prova -s localhost -a file.pdf -r MIME --orareg ora

      ipax c -P 0000003 -A RIVATNCO -O WEBRIVA -I web@comune.rivadelgarda.tn.it -D tiziano@axiastudio.it \\
        -m "problemi con il tuo invio" -s mail.comune.rivadelgarda.tn.it
      
    """
    

def ipax(opts=None, funct='i'):
    
    shortargs = 'F:P:A:O:I:M:T:D:o:m:t:s:a:r:e:'
    longargs = ['protocollo=',
                'ammiinistrazione=',
                'areaomogenea=',
                'indirizzoorigine=',
                'indirizzodestinazione=',
                'tipoorigine=',
                'noteorigine=',
                'data=',
                'oggetto=',
                'messaggio=',
                'txt=',
                'smtp=',
                'attach=',
                'riferimenti=',
                'tipimime=',
                'orareg=',
                'confric=',
                'mittente=']

    global dizmime
    dizmime = {'pdf':'application/pdf',
               'txt':'text/plain',
               'html':'text/html',
               'gif':'image/gif'}

    if opts==None:
        try:
            funct = sys.argv[1]
            opts, args = getopt.getopt(sys.argv[2:], shortargs, longargs)
        except getopt.GetoptError:
            usage()
            sys.exit(2)

    p = protocollo()

    # defaults
    now = time.localtime(time.time())
    p.DataRegistrazione = time.strftime("%Y-%m-%d" , now)
    p.OraRegistrazione = ""
    p.targetDir = "."
    p.serverSMTP = "127.0.0.1"
    p.attach = []
    p.riferimenti = [""]
    p.tipimime = ""
    p.TestoDelMessaggio = ""
    p.TestoAllegato = ""
    p.NoteIndirizzoTelematicoOrigine = ""
    p.TipoIndirizzoTelematicoOrigine = "smtp"
    p.confermaRicezione = "no"
    p.funzione = "invio"

    # funzione pax
    if funct in ("i", "c", "r"):
        p.funzione = funct
    else:
        usage()
        sys.exit()

    # parametri comuni
    for o, a in opts:
        if o in ("-P", "--protocollo"):
            p.NumeroRegistrazione = a
        if o in ("-A", "--amministrazione"):
            p.CodiceAmministrazione = a
        if o in ("-O", "--areaomogenea"):
            p.CodiceAOO = a
        if o in ("-I", "--indirizzoorigine"):
            p.IndirizzoTelematicoOrigine = a
        if o in ("-D", "--indirizzodestinazione"):
            p.IndirizzoTelematicoDestinazione = a
        if o in ("-s", "--smtp"):
            p.serverSMTP = a

    

    # parametri specifici per invio
    if p.funzione == "i":

        for o, a in opts:
            if o in ("-h", "--help"):
                usage()
                sys.exit()
            if o in ("-M", "--mittente"):
                p.denominazioneMittenteAOO = a
            if o in ("--noteorigine",):
                p.NoteIndirizzoTelematicoOrigine = a
            if o in ("--tipoorigine",):
                p.TipoIndirizzoTelematicoOrigine = a
            if o in ("-T", "--data",):
                p.DataRegistrazione = a
            if o in ("--orareg",):
                if a == "ora":
                    p.OraRegistrazione = time.strftime("%H:%M:%S" , now)
                else:
                    p.OraRegistrazione = a
            else:
                p.OraRegistrazione = ""
            if o in ("-o", "--oggetto"):
                p.Oggetto = a
            if o in ("-m", "--messaggio"):
                p.TestoDelMessaggio = a
            if o in ("-t", "--txt"):
                p.TestoAllegato = a
            if o in ("-a", "--attach"):
                p.attach = str(a).split(",")
            if o in ("-r", "--riferimenti"):
                p.riferimenti = str(a).split(",")
            if o in ("-e", "--tipimime"):
                p.tipimime = str(a).split(",")
            if o in ("--confric",) and a == "si":
                p.confermaRicezione = "si"

    # parametri per conferma
    elif p.funzione == "c":
        
        for o, a in opts:
            if o in ("-h", "--help"):
                usage()
                sys.exit()
            if o in ("-P", "--protocollo"):
                p.NumeroRegistrazione = a
            if o in ("-m", "--messaggio"):
                p.TestoDelMessaggio = a


    # testo come primo allegato
    if p.TestoAllegato != "":
        a = "%s.txt" % p.NumeroRegistrazione
        f = open(os.path.join(p.targetDir, a), 'w')

#        raise p.TestoAllegato
    
        f.write(p.TestoAllegato)
        f.flush()
        f.close()
        os.chmod(a,0777)
        p.attach.insert(0, a)


    if p.funzione == "i":
        
        # sistemazione tipi mime degli allegati
        if p.tipimime == "":
            ltm =0
            p.tipimime = []
        else:
            ltm = len(p.tipimime)
        
        for n in range(len(p.attach)):
            a = p.attach[n]
            if n < ltm:
                tt = p.tipimime[n]
                p.tipimime[n] = dizmime.get(tt, tt)
            else:
                tt = a.split('.')[-1]
                p.tipimime.append(dizmime.get(tt, tt))

        xmlout = p.makeXMLSegnatura()
            
    elif p.funzione == "c":
        
        xmlout = p.makeXMLConfermaRicezione()
        
    elif p.funzione == "r":
        
        xmlout = p.makeXMLRipudio()
        

    # xml
    f = open(os.path.join(p.targetDir, p.NumeroRegistrazione + '.xml'), 'w')
    f.write(xmlout)
    f.flush()
    f.close()

    # impronta
    impr = sha.new(xmlout).hexdigest()
    f = open(os.path.join(p.targetDir, p.NumeroRegistrazione + '.sha'), 'w')
    f.write(impr)
    f.flush()
    f.close()

    # busta mime
    mimeout = p.makeMIME(xmlout, impr)
    f = open(os.path.join(p.targetDir, p.NumeroRegistrazione + '.mime'), 'w')
    f.write(mimeout)
    f.flush()
    f.close()
    
    outbox = smtplib.SMTP(p.serverSMTP)
    outbox.sendmail(p.IndirizzoTelematicoOrigine, [p.IndirizzoTelematicoDestinazione], mimeout)
    outbox.quit()
    

    res = "Debug: \n\n%s\n\n%s\n" % (p.attach, p.tipimime)

    print "\n%s\n" % opts
    return

        


class protocollo:
    "oggetto protocollo informatico"

    def __init__(self):
        "qwe"



        
    def makeMIME(self, xml, impr):
        "genera un messaggio MIME"

        writer = StringIO()
        fxml = open(os.path.join(self.targetDir, self.NumeroRegistrazione + '.xml'), 'r')
        msg = MimeWriter.MimeWriter(writer)

        msg.addheader("From", "%s <%s>" % (self.CodiceAmministrazione, self.IndirizzoTelematicoOrigine) )
        msg.addheader("Reply-To", self.IndirizzoTelematicoOrigine)
        msg.addheader("To", self.IndirizzoTelematicoDestinazione)
        msg.addheader("Subject", "Busta SMTP/MIME")

        boundary = mimetools.choose_boundary()

        dummy = msg.startmultipartbody("mixed",boundary)
        dummy.write("This is a multi-part message in MIME format.\n")

        # parte testuale
        submsg = msg.nextpart()
        submsg.addheader("Content-Transfer-Encoding", "7bit")
        textpart = submsg.startbody("text/plain; charset=us-ascii")
        textpart.write("%s\n" % self.TestoDelMessaggio)


        # segnatura XML
        submsg2 = msg.nextpart()
        submsg2.addheader("Content-Transfer-Encoding", "base64")
        submsg2.addheader("Content-Disposition", "inline;\n\tfilename=\"Segnatura.xml\"")
        xmlpart = submsg2.startbody("application/x-unknow-content-type-xml_auto_file;\n\tname=\"Segnatura.xml\"")
        mimetools.encode(fxml , writer, "base64")

        # testo allegato (es. 00000001.txt)
        #if self.TestoAllegato != "":
        #    a = "%s.txt" % self.NumeroRegistrazione
        #    submsg3 = msg.nextpart()
        #    submsg3.addheader("Content-Transfer-Encoding", "base64")
        #    submsg3.addheader("Content-Disposition", "inline;\n\tfilename=\"%s\"" % a)
        #    apppart = submsg3.startbody("%s\n\tname=\"%s\"" % ('plain/txt', a))
        #    fatt = open(os.path.join(self.targetDir, a), 'rb')
        #    mimetools.encode(fatt, writer, "base64")
        #    fatt.close()

 
        # allegati
        for n in range(len(self.attach)):
            a = self.attach[n]
            submsg3 = msg.nextpart()
            submsg3.addheader("Content-Transfer-Encoding", "base64")
            submsg3.addheader("Content-Disposition", "inline;\n\tfilename=\"%s\"" % a)
            t = self.tipimime[n]
            apppart = submsg3.startbody("%s\n\tname=\"%s\"" % (t, a))
            fatt = open(os.path.join(self.targetDir, a), 'rb')
            mimetools.encode(fatt, writer, "base64")
            fatt.close()
 
        # chiusura
        msg.lastpart()
        fxml.close()

        mimeout = writer.getvalue()

        return mimeout



    def makeXMLConfermaRicezione(self):
        "genera la segnatura XML ConfermaRicezione"

        DOM = xml.dom.minidom.Document()

        # <!ELEMENT ConfermaRicezione (Identificatore, MessaggioRicevuto, Note?)>
        # <!ATTLIST ConfermaRicezione
        #         versione NMTOKEN #FIXED "%dataPubblicazione;"
        #         xml:lang NMTOKEN #FIXED "it"
        #         tipoAccettazione (provvisoria | definitiva) "definitiva"
        # >
        ConfermaRicezioneElement = DOM.createElement("ConfermaRicezione")
        ConfermaRicezioneElement.setAttribute("versione", "2000-10-18")
        ConfermaRicezioneElement.setAttribute("lang", "it")
        DOM.appendChild(ConfermaRicezioneElement)
            
        # <!ELEMENT Identificatore (CodiceAmministrazione, CodiceAOO, NumeroRegistrazione, DataRegistrazione)>
        IdentificatoreElement = DOM.createElement("Identificatore")
        ConfermaRicezioneElement.appendChild(IdentificatoreElement)

        # <!ELEMENT CodiceAmministrazione (#PCDATA)>
        CodiceAmministrazioneElement = DOM.createElement("CodiceAmministrazione")
        IdentificatoreElement.appendChild(CodiceAmministrazioneElement)
        CodiceAmministrazioneText = DOM.createTextNode(self.CodiceAmministrazione)
        CodiceAmministrazioneElement.appendChild(CodiceAmministrazioneText)

        # <!ELEMENT CodiceAOO (#PCDATA)>
        CodiceAOOElement = DOM.createElement("CodiceAOO")
        IdentificatoreElement.appendChild(CodiceAOOElement)
        CodiceAOOText = DOM.createTextNode(self.CodiceAOO)
        CodiceAOOElement.appendChild(CodiceAOOText)

        # <!ELEMENT NumeroRegistrazione (#PCDATA)>
        NumeroRegistrazioneElement = DOM.createElement("NumeroRegistrazione")
        IdentificatoreElement.appendChild(NumeroRegistrazioneElement)
        NumeroRegistrazioneText = DOM.createTextNode(self.NumeroRegistrazione)
        NumeroRegistrazioneElement.appendChild(NumeroRegistrazioneText)

        # <!ELEMENT DataRegistrazione (#PCDATA)>
        DataRegistrazioneElement = DOM.createElement("DataRegistrazione")
        IdentificatoreElement.appendChild(DataRegistrazioneElement)
        DataRegistrazioneText = DOM.createTextNode(self.DataRegistrazione)
        DataRegistrazioneElement.appendChild(DataRegistrazioneText)

        # Originale:
        # <!ELEMENT MessaggioRicevuto ((Identificatore, PrimaRegistrazione?) | DescrizioneMessaggio)>
        #
        # Attuale:
        # <!ELEMENT MessaggioRicevuto (DescrizioneMessaggio)>        
        MessaggioRicevutoElement = DOM.createElement("MessaggioRicevuto")
        ConfermaRicezioneElement.appendChild(MessaggioRicevutoElement)

        # <!ELEMENT DescrizioneMessaggio (#PCDATA)>
        DescrizioneMessaggioElement = DOM.createElement("DescrizioneMessaggio")
        MessaggioRicevutoElement.appendChild(DescrizioneMessaggioElement)
        DescrizioneMessaggioText = DOM.createTextNode(self.TestoDelMessaggio)
        DescrizioneMessaggioElement.appendChild(DescrizioneMessaggioText)
        

        # questo ? il metodo per aggirare il fatto che Document.toxml non scrive l'encoding
        writer = StringIO()
        writer.write('<?xml version="1.0" encoding="UTF-8" ?>\n')
        writer.write('<!DOCTYPE ConfermaRicezione SYSTEM "Segnatura.dtd">\n')
        for node in DOM.childNodes:
            node.writexml(writer, "", "\t", "\n")
        xmlout = writer.getvalue()

        return xmlout

        
        
    def makeXMLSegnatura(self):
        "genera la segnatura XML "

        DOM = xml.dom.minidom.Document()

        # Originale:
        # <!ELEMENT Segnatura (Intestazione, Riferimenti?, Descrizione?)>
        # <!ATTLIST Segnatura
        #         versione NMTOKEN #FIXED "%dataPubblicazione;"
        #         xml:lang NMTOKEN #FIXED "it"
        # >
        #
        # Attuale:
        # <!ELEMENT Segnatura (Intestazione, Descrizione?)>
        # <!ATTLIST Segnatura
        #         versione NMTOKEN #FIXED "%dataPubblicazione;"
        #         xml:lang NMTOKEN #FIXED "it"
        # >
        SegnaturaElement = DOM.createElement("Segnatura")
        SegnaturaElement.setAttribute("versione", "2000-10-18")
        SegnaturaElement.setAttribute("lang", "it")
        DOM.appendChild(SegnaturaElement)

        # Originale:
        # <!ELEMENT Intestazione (Identificatore, PrimaRegistrazione?, OraRegistrazione?,
        #                         Origine, Destinazione+, PerConoscenza*, Risposta?, Riservato?,
        #                         InterventoOperatore?, RiferimentoDocumentiCartacei?, Oggetto,
        #                         Classifica*, Note?)>    
        #
        # Attuale:
        # <!ELEMENT Intestazione (Identificatore, OraRegistrazione?,
        #                         Origine, Destinazione, Oggetto)>
        IntestazioneElement = DOM.createElement("Intestazione")
        SegnaturaElement.appendChild(IntestazioneElement)

        # <!ELEMENT Identificatore (CodiceAmministrazione, CodiceAOO, NumeroRegistrazione, DataRegistrazione)>
        IdentificatoreElement = DOM.createElement("Identificatore")
        IntestazioneElement.appendChild(IdentificatoreElement)

        # <!ELEMENT CodiceAmministrazione (#PCDATA)>
        CodiceAmministrazioneElement = DOM.createElement("CodiceAmministrazione")
        IdentificatoreElement.appendChild(CodiceAmministrazioneElement)
        CodiceAmministrazioneText = DOM.createTextNode(self.CodiceAmministrazione)
        CodiceAmministrazioneElement.appendChild(CodiceAmministrazioneText)

        # <!ELEMENT CodiceAOO (#PCDATA)>
        CodiceAOOElement = DOM.createElement("CodiceAOO")
        IdentificatoreElement.appendChild(CodiceAOOElement)
        CodiceAOOText = DOM.createTextNode(self.CodiceAOO)
        CodiceAOOElement.appendChild(CodiceAOOText)

        # <!ELEMENT NumeroRegistrazione (#PCDATA)>
        NumeroRegistrazioneElement = DOM.createElement("NumeroRegistrazione")
        IdentificatoreElement.appendChild(NumeroRegistrazioneElement)
        NumeroRegistrazioneText = DOM.createTextNode(self.NumeroRegistrazione)
        NumeroRegistrazioneElement.appendChild(NumeroRegistrazioneText)

        # <!ELEMENT DataRegistrazione (#PCDATA)>
        DataRegistrazioneElement = DOM.createElement("DataRegistrazione")
        IdentificatoreElement.appendChild(DataRegistrazioneElement)
        DataRegistrazioneText = DOM.createTextNode(self.DataRegistrazione)
        DataRegistrazioneElement.appendChild(DataRegistrazioneText)
            
        # <!ELEMENT PrimaRegistrazione (Identificatore)>  non ancora trattata!!
        
        # Originale:
        # <!ELEMENT OraRegistrazione (#PCDATA)>
        # <!ATTLIST OraRegistrazione
        #         tempo (locale | rupa | CDATA) "locale"
        # >
        #
        # Attuale:
        # <!ELEMENT OraRegistrazione (#PCDATA)>
        # <!ATTLIST OraRegistrazione
        #         tempo  #FIXED "locale"
        # >        
        if self.OraRegistrazione != "":
            OraRegistrazioneElement = DOM.createElement("OraRegistrazione")
            OraRegistrazioneElement.setAttribute("tempo", "locale")
            IntestazioneElement.appendChild(OraRegistrazioneElement)
            OraRegistrazioneText = DOM.createTextNode(self.OraRegistrazione)
            OraRegistrazioneElement.appendChild(OraRegistrazioneText)
        
        
        # <!ELEMENT Origine (IndirizzoTelematico, Mittente)>
        OrigineElement = DOM.createElement("Origine")
        IntestazioneElement.appendChild(OrigineElement)

        # <!ELEMENT IndirizzoTelematico (#PCDATA)>
        # <!ATTLIST IndirizzoTelematico
        #         tipo (smtp | url | CDATA) "smtp"
        #         note CDATA #IMPLIED
        # >
        IndirizzoTelematicoElement = DOM.createElement("IndirizzoTelematico")
        OrigineElement.appendChild(IndirizzoTelematicoElement)
        IndirizzoTelematicoText = DOM.createTextNode(self.IndirizzoTelematicoOrigine)
        IndirizzoTelematicoElement.setAttribute("tipo", self.TipoIndirizzoTelematicoOrigine)
        if len(self.NoteIndirizzoTelematicoOrigine) > 0:
            IndirizzoTelematicoElement.setAttribute("note", self.NoteIndirizzoTelematicoOrigine)
        IndirizzoTelematicoElement.appendChild(IndirizzoTelematicoText)

        # <!ELEMENT Mittente (Amministrazione, AOO)>
        MittenteElement = DOM.createElement("Mittente")
        OrigineElement.appendChild(MittenteElement)

        # Originale:
        # <!ELEMENT Amministrazione (Denominazione, CodiceAmministrazione?,
        #  (UnitaOrganizzativa | (Persona*, IndirizzoPostale, IndirizzoTelematico*, Telefono*, Fax*)))?>
        #
        # Attuale:
        # <!ELEMENT Amministrazione>
        AmministrazioneElement = DOM.createElement("Amministrazione")
        MittenteElement.appendChild(AmministrazioneElement)

        # Originale:
        # <!ELEMENT AOO (Denominazione, CodiceAOO?)>
        #
        # Attuale:
        # <!ELEMENT AOO (Denominazione)>
        AOOElement = DOM.createElement("AOO")
        MittenteElement.appendChild(AOOElement)

        # <!ELEMENT Denominazione (#PCDATA)>
        DenominazioneElement = DOM.createElement("Denominazione")
        AOOElement.appendChild(DenominazioneElement)
        DenominazioneText = DOM.createTextNode(self.denominazioneMittenteAOO)
        DenominazioneElement.appendChild(DenominazioneText)
            
        # Originale:
        # <!ELEMENT Destinazione (IndirizzoTelematico, Destinatario*)>
        # <!ATTLIST Destinazione
        #         confermaRicezione (si | no) "no"
        # >
        #
        # Attuale:
        # <!ELEMENT Destinazione (IndirizzoTelematico)>
        # <!ATTLIST Destinazione
        #         confermaRicezione (si | no) "no"
        # >
        DestinazioneElement = DOM.createElement("Destinazione")
        DestinazioneElement.setAttribute("confermaRicezione", self.confermaRicezione)
        IntestazioneElement.appendChild(DestinazioneElement)

        # Originale:
        # <!ELEMENT IndirizzoTelematico (#PCDATA)>
        # <!ATTLIST IndirizzoTelematico
        #         tipo (smtp | url | CDATA) "smtp"
        #         note CDATA #IMPLIED
        # >
        #
        # Attuale:
        # <!ELEMENT IndirizzoTelematico (#PCDATA)>
        # <!ATTLIST IndirizzoTelematico
        #         tipo "smtp"
        #         note CDATA #IMPLIED
        # >
        IndirizzoTelematicoElement = DOM.createElement("IndirizzoTelematico")
        IndirizzoTelematicoElement.setAttribute("tipo", "smtp")
        DestinazioneElement.appendChild(IndirizzoTelematicoElement)
        IndirizzoTelematicoText = DOM.createTextNode(self.IndirizzoTelematicoDestinazione)
        IndirizzoTelematicoElement.appendChild(IndirizzoTelematicoText)

        # <!ELEMENT Oggetto (#PCDATA)>
        OggettoElement = DOM.createElement("Oggetto")
        IntestazioneElement.appendChild(OggettoElement)
        OggettoText = DOM.createTextNode(self.Oggetto)
        OggettoElement.appendChild(OggettoText)

        # Originale:
        # <!ELEMENT Descrizione ((Documento | TestoDelMessaggio), Allegati?, Note?)>
        #
        # Attuale:
        # <!ELEMENT Descrizione (Documento | TestoDelMessaggio)>
        if len(self.TestoDelMessaggio) > 0 or len(self.attach) > 0:   # e' opzionale!
            DescrizioneElement = DOM.createElement("Descrizione")
            SegnaturaElement.appendChild(DescrizioneElement)
        
            # <!ELEMENT TestoDelMessaggio EMPTY>
            # <!ATTLIST TestoDelMessaggio
            #         id CDATA #IMPLIED
            #         tipoMIME CDATA #IMPLIED
            #         tipoRiferimento NMTOKEN #FIXED "MIME"
            # >
            # e' il testo del messaggio mime
            if len(self.TestoDelMessaggio) > 0: 
                TestoDelMessaggioElement = DOM.createElement("TestoDelMessaggio")
                TestoDelMessaggioElement.setAttribute("id", "%s.txt" % self.NumeroRegistrazione) #!
                TestoDelMessaggioElement.setAttribute("tipoMIME", "text/plain") #!
                TestoDelMessaggioElement.setAttribute("tipoRiferimento", "MIME") #!
                DescrizioneElement.appendChild(TestoDelMessaggioElement)

            # Originale:
            # <!ELEMENT Documento ((URI, Impronta?)?, TitoloDocumento?, PrimaRegistrazione?,
            #         TipoDocumento?, Oggetto?, Classifica*, NumeroPagine?, Note?)>
            # <!ATTLIST Documento
            #         id ID #IMPLIED
            #         rife IDREF #IMPLIED
            #         nome CDATA #IMPLIED
            #         tipoMIME CDATA #IMPLIED
            #         tipoRiferimento (MIME | informatico | cartaceo) "MIME"
            # >
            #
            # Attuale:
            # <!ELEMENT Documento>
            # <!ATTLIST Documento
            #         id ID #IMPLIED
            #         nome CDATA #IMPLIED
            #         tipoMIME CDATA #IMPLIED
            #         tipoRiferimento NMTOKEN #FIXED "MIME"
            # >
            
            else:
                Documento = DOM.createElement("Documento")
                if self.riferimenti[0] == "MIME" or len(self.riferimenti[0]) == 0:
                    Documento.setAttribute("tipoRiferimento","MIME") 
                    Documento.setAttribute("id", self.attach[0])        # utilizzo opzionale come id univoco nell'xml
                    Documento.setAttribute("nome", self.attach[0])      # e' il filename di Content-Disposition
                    if len(self.tipimime[0]) > 0:
                        Documento.setAttribute("tipoMIME", self.tipimime[0])
                    else:
                        ext = self.attach[0].split('.')[-1]
                        tipomime = dizmime.get(ext, ext) 
                        Documento.setAttribute("tipoMIME", "%s" % tipomime)
                elif self.riferimenti[0] == "informatico":
                    Documento.setAttribute("tipoRiferimento","informatico") 
                    Documento.setAttribute("id", self.attach[0])   # utilizzo opzionale come id univoco nell'xml
                    Documento.setAttribute("tipoRiferimento","informatico")
                    if len(self.tipimime[0]) > 0:
                        Documento.setAttribute("tipoMIME", self.tipimime[0])
                    else:
                        tipomime = "text/plain" # che tipo mime per i link ??
                        Documento.setAttribute("tipoMIME", "%s" % tipomime)
                elif self.riferimenti[0] == "cartaceo":
                    Documento.setAttribute("tipoRiferimento","cartaceo")
                    Documento.setAttribute("id", self.attach[0])   # identif. documento cartaceo (occhio a PrimaRegistrazione!!)
                DescrizioneElement.appendChild(Documento)


        # questo ? il metodo per aggirare il fatto che Document.toxml non scrive l'encoding
        writer = StringIO()
        writer.write('<?xml version="1.0" encoding="UTF-8" ?>\n')
        writer.write('<!DOCTYPE Segnatura SYSTEM "Segnatura.dtd">\n')
        for node in DOM.childNodes:
            node.writexml(writer, "", "\t", "\n")
        xmlout = writer.getvalue()

        return xmlout



if __name__ == '__main__': ipax()
