#                                                       #
#               Test PloneMinimalProduct                #
#                                                       #
# (c)2002 Ingeniweb                                     #

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))



# Load fixture
from Testing import ZopeTestCase

# Permissions / security
from AccessControl.Permissions import access_contents_information, view, add_documents_images_and_files, change_images_and_files, view_management_screens
from AccessControl.SecurityManagement import newSecurityManager, noSecurityManager, getSecurityManager
from AccessControl import Unauthorized
from Products.CMFCore.CMFCorePermissions import *
from AccessControl.User import UnrestrictedUser

_standard_permissions = ZopeTestCase._standard_permissions
_member_permissions   = [ListPortalMembers, ListUndoableChanges, ReplyToItem, SetOwnPassword, SetOwnProperties, ] + _standard_permissions  # Plone member permissions
_access_permissions   = [view_management_screens,]                      # Access attachment attributes (this is a silly permissions, for test purposes only)
_edit_permissions     = [change_images_and_files,]                      # Edit attachment attributes (silly permission as well)
_all_permissions      = _standard_permissions+_access_permissions

    
# Get global vars
from Products.PloneMinimalProduct.global_symbols import *


# Other imports
from Products.CMFCore.utils import getToolByName


# Install CMF/Plone products
ZopeTestCase.installProduct('ExternalMethod')
ZopeTestCase.installProduct('PageTemplates')
ZopeTestCase.installProduct('DCWorflow')
ZopeTestCase.installProduct('CMFCore')
ZopeTestCase.installProduct('CMFTopic')
ZopeTestCase.installProduct('CMFCalendar')
ZopeTestCase.installProduct('CMFDefault')
ZopeTestCase.installProduct('CMFPlone')
ZopeTestCase.installProduct('MailHost')

# Install our product
ZopeTestCase.installProduct('PloneMinimalProduct')


# Set log options if Log module is available
# This is done to set LOG_PROCESSORs to file logs instead of Zope logs
try:
    import Log

    Log.LOG_LEVEL = Log.LOG_DEBUG

    Log.LOG_PROCESSOR = {
        Log.LOG_NONE: Log.logFile,
        Log.LOG_CRITICAL: Log.logFile,
        Log.LOG_ERROR: Log.logFile,
        Log.LOG_WARNING: Log.logFile,
        Log.LOG_NOTICE: Log.logFile,
        Log.LOG_DEBUG: Log.logFile,
        }

    from Log import *
    Log(LOG_NOTICE, "Starting %s at %d debug level" % (os.path.dirname(__file__), LOG_LEVEL, ))

except:
    print "Log module not available"
    LOG_DEBUG = None
    LOG_NOTICE = None
    LOG_WARNING = None
    LOG_ERROR = None
    LOG_CRITICAL = None
    def Log(*args, **kw):
        pass
    raise


def getHomePageText():
    return r"This is %s's default homepage text."



class TestPloneMinimalProduct(ZopeTestCase.ZopeTestCase):


    def login(self, user = None):
        "user must be an acl_user's user"
        self.logout()                   # Is this necessary ? Well, at least, it's clean.
        if not user:
            user = self._user
        newSecurityManager(None, user)

    def loginMember(self, name):
        uf = self.plone.acl_users
        self.login(uf.getUserById(name).__of__(uf))             # The __of__ is necessary in order to make Owned.ownerInfo (line 239 of AccessControl.Owned) work


    def joinMember(self, name):
        """
        joinMember(self, name) => (Zope) user object
        create a member and his private space.
        Must be called after self.plone, self.membership_tool, self.homePageText and self.memberdata_tool have been set.
        """
        # $$$ It would be better if we could use the "join" machinery but I cannot make it work.
        uf = self.plone.acl_users
        self.plone.portal_registration.addMember(
            name,
            'secret',
            properties={
            'username': name,
            'email' : 'foo@bar.com',
            }
            )

        # Get Zope user and CMF member objects
        u = uf.getUserById(name).__of__(uf)
        self.login(u)
        member = self.membership_tool.getAuthenticatedMember()

        # Create member area if necessary
        portal_user = self.memberdata_tool.wrapUser(u)
        if self.membership_tool.getHomeUrl(portal_user.getId()) is None:
            Log(LOG_DEBUG, "Create personal member area for %s" % (name, ))
            self.membership_tool.createMemberarea(portal_user.getId())
        Log(LOG_DEBUG, "Joined user '%s'" % (name,))
        return u


    
    def afterSetUp(self,):
        """
        afterSetUp(self) => This method is called to create an empty Plone Site with a MinimalProduct inside you're gonna play with.

        It also joins three users called 'user1', 'user2' and 'user3'.

        And, eventually, it installs the CMFType with an external method.
        """
        # Create Plone instance
        self.folder.manage_addProduct['CMFPlone'].manage_addSite(
            id = 'plone',
            title = 'Sample Plone website',
            description = 'This is a sample Plone website meant to be used in a ZopeTestCase',
            email_from_address='postmaster@localhost',
            email_from_name='Portal Administrator',
            validate_email=0,
            custom_policy='',
            RESPONSE=None)
        self.plone = self.folder.plone
        self.plone.portal_membership.memberareaCreationFlag = 0         # We have to create member areas by hand. Don't know exactly why it cannot work automatically.
        self.plone.homePageText = getHomePageText                       # Overrides default portal member text (this is documented in Plone's source)

        # Create tool aliases
        self.membership_tool = getToolByName(self.plone, "portal_membership")
        self.memberdata_tool = getToolByName(self.plone, "portal_memberdata")

        # Create a few members
        self.user1 = self.joinMember("user1")
        self.user2 = self.joinMember("user2")
        self.user3 = self.joinMember("user3")

        self.failUnless('user1' in self.plone.Members.objectIds())
        self.failUnless('user2' in self.plone.Members.objectIds())
        self.failUnless('user3' in self.plone.Members.objectIds())

        # Wow ! Seems to work ! :-)
        Log(LOG_DEBUG, "Plone instance loaded and users instanciated")

        # Now, installs our product's type
        self.plone.manage_addProduct['ExternalMethod'].manage_addExternalMethod(
            id='PloneMinimalProductInstall',
            title="Install PloneMinimalProduct",
            module="PloneMinimalProduct.Install",
            function="install"
            )
        ExMethod = self.plone.restrictedTraverse('PloneMinimalProductInstall')
        ExMethod()
    

    def test_00_createContent(self,):
        """
        Create new folder in home directory & check its basic properties and behaviour
        """
        # Login
        self.loginMember("user1")
        home = self.membership_tool.getHomeFolder()

        # Content creation
        content_id = "sample_folder"
        self.membership_tool.getHomeFolder().invokeFactory(
            type_name = 'MinimalFolderishType',
            id = content_id
            )
        self.failUnless(content_id in home.objectIds(), "Object has not been created or not with the right id")
        content = getattr(home, content_id)

        # Basic checks
        self.assertEqual(content.title, '')
        self.assertEqual(content.id, content_id)

        # Youpie
        Log(LOG_NOTICE, "MinimalFolderishType instanciated correctly !")
        
            


if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
else:
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(TestPloneMinimalProduct))
        return suite

