from Globals import DTMLFile, ImageFile
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from OFS.PropertyManager import PropertyManager
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo, getSecurityManager
from OFS.Folder import Folder
from OFS.SimpleItem import Item
from Products.TemporaryFolder.TemporaryFolder import MountedTemporaryFolder
import Products.ZPsycopgDA.DA
from mx.DateTime import *
import smtplib

from email.MIMEText import MIMEText
from email.MIMEImage import MIMEImage
from email.MIMEBase import MIMEBase

from Products.Pratiche import utils

# Classe principale dell'applicazione

class Commercio(Folder):    
    "Folder dell'applicazione Commercio lato Zope"

    down=ImageFile('www/down.png', globals())

    security = ClassSecurityInfo()
    
    __ac_roles__=('pax_webuser',
                  'Manager',
                  'Anonymous')


    meta_type = 'PAX - Commercio Application'
  
    manage_options = (
        (
        {'label':'Contents', 'action':'manage_main'},
        {'label':'View', 'action':'index_html'},
        ) +
        PropertyManager.manage_options +
        RoleManager.manage_options +
        Item.manage_options
    )

## no buono  security.declareProtected('Pax Use', 'index_html')   
##    index_html = PageTemplateFile('template/index_html.pt', globals())

    security.declareProtected('Pax Use', 'viewPratiche')   
    viewPratiche = PageTemplateFile('template/viewPratiche.pt', globals())

    security.declareProtected('Pax Use', 'view_pratica')   
    view_pratica = PageTemplateFile('template/viewPratica.pt', globals())

    security.declarePublic('Pax Use', 'showPeriodo')
    showPeriodo = PageTemplateFile('template/show_periodo.pt', globals())

    security.declarePublic('Pax Use', 'modifyPeriodo')
    modifyPeriodo = PageTemplateFile('template/modifyPeriodo.pt', globals())

    security.declarePublic('Pax Use', 'temporanea')
    temporanea = PageTemplateFile('template/temporanea.pt', globals())
    
    def __init__(self, id):
        "initialise a new instance of Commercio Application"
        self.id = id

    security.declareProtected('Pax Add Commercio', 'manage_editCommercioAction')
    def manage_editCommercioAction(self, RESPONSE=None):
        "Edit Commercio Application."
        self._p_changed = 1
        RESPONSE.redirect('manage_main')

        return

    security.declarePublic('Pax Use', 'getDaysOfWeek')
    def getDaysOfWeek(self):
        "Giorni settimana."
        days = {}
        days = ({'id':1,'desc':'Lunedi','idcampo':'lu'},
                {'id':2,'desc':'Martedi','idcampo':'ma'},
                {'id':3,'desc':'Mercoledi','idcampo':'me'},
                {'id':4,'desc':'Giovedi','idcampo':'gi'},
                {'id':5,'desc':'Venerdi','idcampo':'ve'},
                {'id':6,'desc':'Sabato','idcampo':'sa'},
                {'id':7,'desc':'Domenica','idcampo':'do'})

        return days


    security.declarePublic('Pax Use', 'getDays')
    def getDays(self):

        days = range(1,32)

        return days

    security.declarePublic('Pax Use', 'getMonths')
    def getMonths(self):

        days = range(1,13)

        return days



    security.declarePublic('Pax Use', 'getHours')
    def getHours(self):
        hours = [{'id':'--','desc':'-'}]
        for i in range(24):
            hour={'id':'%02d' % (i,),'desc':"%02d" % (i,)}
            hours.append(hour)

        return hours


    security.declarePublic('Pax Use', 'copyOldValues')
    def copyOldValues(self,REQUEST=None):
        hours = [{'id':'--','desc':'-'}]
        for i in range(24):
            hour={'id':'%02d' % (i,),'desc':"%02d" % (i,)}
            hours.append(hour)

        return hours



    security.declarePublic('Pax Use', 'approveOrari')
    def approveOrari(self,REQUEST=None):

        id_pratica =  getattr(REQUEST,'id_pratica')        

        sql_string = "delete from chiusura where id_pratica = '%s'" % (id_pratica)

        utils.runQuery(self.getConnection(),sql_string)
        
        data_inserimento = now().strftime("%d/%m/%Y")

        anno = now().strftime("%Y")

        giornochiusura=getattr(REQUEST,'giornochiusura','')
        mezzagiornata=getattr(REQUEST,'mezzagiornata','')        

        sql_string = "INSERT into chiusura (id_pratica, anno, giornochiusura, mezzagiornata, data_inserimento, utente_inserimento ) VALUES ('%s' , '%s',  '%s', '%s', '%s', '%s')" % (id_pratica, anno, giornochiusura, mezzagiornata, data_inserimento, '')

        utils.runQuery(self.getConnection(),sql_string)


        perioditodelete = self.sqlGetPeriodi(id_pratica=getattr(REQUEST,'id_pratica',''))

        for periodo in perioditodelete:
            sql_string = "UPDATE periodi set deleted = 1 WHERE id = '%s'" % periodo['id']
            utils.runQuery(self.getConnection(),sql_string)

        periodi = self.sqlGetToApprovePeriodi(id_pratica=getattr(REQUEST,'id_pratica',''))
        
        for periodo in periodi:

            if periodo['data_inserimento']==None:
                data_inserimento='NULL'
            else:
                data_inserimento=periodo['data_inserimento']
                
            sql_string = "insert into periodi (id_pratica, id_attivita,  numero , anno , dal , al , data_inserimento, utente_inserimento,  ludalle1, lualle1, ludalle2, lualle2, madalle1, maalle1, madalle2 ,maalle2, medalle1, mealle1, medalle2, mealle2, gidalle1, gialle1, gidalle2, gialle2, vedalle1, vealle1, vedalle2, vealle2, sadalle1, saalle1, sadalle2, saalle2, dodalle1, doalle1, dodalle2, doalle2 ) VALUES ('%s','%s','%s','%s','%s','%s', '%s','%s', '%s','%s','%s','%s' ,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')" % (periodo['id_pratica'], periodo['id_attivita'], periodo['numero'], periodo['anno'], periodo['dal'], periodo['al'], data_inserimento, periodo['utente_inserimento'], periodo['ludalle1'], periodo['lualle1'], periodo['ludalle2'], periodo['lualle2'], periodo['madalle1'], periodo['maalle1'], periodo['madalle2'] ,periodo['maalle2'], periodo['medalle1'], periodo['mealle1'], periodo['medalle2'], periodo['mealle2'], periodo['gidalle1'], periodo['gialle1'], periodo['gidalle2'], periodo['gialle2'], periodo['vedalle1'], periodo['vealle1'], periodo['vedalle2'], periodo['vealle2'], periodo['sadalle1'], periodo['saalle1'], periodo['sadalle2'], periodo['saalle2'], periodo['dodalle1'], periodo['doalle1'], periodo['dodalle2'], periodo['doalle2'] )

            utils.runQuery(self.getConnection(),sql_string)

            # cancello i periodi approvati dalla lista dei proposti
            sql_string = "UPDATE toapproveperiodi set deleted = 1 WHERE id = '%s'" % periodo['id']
            utils.runQuery(self.getConnection(),sql_string)

        REQUEST.RESPONSE.redirect(REQUEST['URL1']+'/view_pratica?id_pratica=' + id_pratica)


    security.declarePublic('Pax Use', 'getMins')
    def getMins(self):
        mins = [{'id':'--','desc':'-'}]
        for i in range(60):
            min={'id':'%02d' % (i,),'desc':"%02d" % (i,)}
            mins.append(min)

        return mins

    security.declarePublic('Pax Use', 'savePaxData')
    def savePaxData(self,REQUEST=None):
        
        mins = [{'id':'--','desc':'-'}]
        for i in range(60):
            min={'id':'%02d' % (i,),'desc':"%02d" % (i,)}
            mins.append(min)

        return mins


    security.declarePublic('Pax Use', 'getAttivita')
    def getAttivita(self,attivita, id):
        for att in attivita:
            if att['id']==id:
                return att['descrizione']

    security.declarePublic('Pax Use', 'getPeriodo')
    def getPeriodo(self,REQUEST=None):
        "Returns a period"

        request=REQUEST
        
        queryParams={}

        if request.has_key('id_pratica'):
            queryParams['id_pratica']=request['id_pratica']

        if request.has_key('id'):
            if len(request['id']) > 0:
                queryParams['id']=request['id']
  
        periods = self.sqlGetPeriodo(queryParams)

        periodo = {}
        for rows in periods:
            periodo['id_pratica']=rows['id_pratica']
            periodo['id_attivita']=rows['id_attivita']
            periodo['id']=rows['id']
            periodo['numero']=rows['numero']
            dal=rows['dal']
            al=rows['al']
            periodo['dal']=dal
            periodo['al']=al
            periodo['dalmese']=dal.strftime('%m')
            periodo['dalgiorno']=dal.strftime('%d')
            if periodo['dalgiorno'][0]=='0':
                periodo['dalgiorno']=periodo['dalgiorno'][1]
            periodo['almese']=al.strftime('%m')
            periodo['algiorno']=al.strftime('%d')
            if periodo['algiorno'][0]=='0':
                periodo['algiorno']=periodo['algiorno'][1]            
            
            periodo['descrizione']=rows['descrizione']
#            periodo['data_approvazione']=rows['data_approvazione']
#            periodo['utente_approvazione']=rows['utente_approvazione']                        

            for item in self.getDaysOfWeek():
                if len(rows[item['idcampo']+ 'dalle1'])>=4:
                    periodo[item['idcampo']+'dalleora1']=rows[item['idcampo']+ 'dalle1'][:2]
                    periodo[item['idcampo']+'dallemin1']=rows[item['idcampo']+ 'dalle1'][2:4]
                if len(rows[item['idcampo']+ 'alle1'])>=4:
                    periodo[item['idcampo']+'alleora1']=rows[item['idcampo']+ 'alle1'][:2]
                    periodo[item['idcampo']+'allemin1']=rows[item['idcampo']+ 'alle1'][2:4]
                if len(rows[item['idcampo']+ 'dalle2'])>=4:                    
                    periodo[item['idcampo']+'dalleora2']=rows[item['idcampo']+ 'dalle2'][:2]
                    periodo[item['idcampo']+'dallemin2']=rows[item['idcampo']+ 'dalle2'][2:4]
                if len(rows[item['idcampo']+ 'alle2'])>=4:                    
                    periodo[item['idcampo']+'alleora2']=rows[item['idcampo']+ 'alle2'][:2]
                    periodo[item['idcampo']+'allemin2']=rows[item['idcampo']+ 'alle2'][2:4]
               
        return periodo

    security.declarePublic('Pax Use', 'getToApprovePeriodo')
    def getToApprovePeriodo(self,REQUEST=None):
        "Returns a period"

        request=REQUEST
        
        queryParams={}

        if request.has_key('id_pratica'):
            queryParams['id_pratica']=request['id_pratica']

        if request.has_key('id'):
            if len(request['id']) > 0:
                queryParams['id']=request['id']
        else:
            queryParams['id']='-1' # nothing to do..
  
        periods = self.sqlGetToApprovePeriodo(queryParams)

        periodo = {}
        for rows in periods:
            periodo['id_pratica']=rows['id_pratica']
            periodo['id_attivita']=rows['id_attivita']
            periodo['id']=rows['id']
            periodo['numero']=rows['numero']
            dal=rows['dal']
            al=rows['al']
            periodo['dal']=dal
            periodo['al']=al
            periodo['dalmese']=dal.strftime('%m')
            periodo['dalgiorno']=dal.strftime('%d')
            if periodo['dalgiorno'][0]=='0':
                periodo['dalgiorno']=periodo['dalgiorno'][1]
            periodo['almese']=al.strftime('%m')
            periodo['algiorno']=al.strftime('%d')
            if periodo['algiorno'][0]=='0':
                periodo['algiorno']=periodo['algiorno'][1]            
            periodo['descrizione']=rows['descrizione']
            periodo['data_approvazione']=rows['data_approvazione']
            periodo['utente_approvazione']=rows['utente_approvazione']                        

            for item in self.getDaysOfWeek():
                if len(rows[item['idcampo']+ 'dalle1'])>=4:
                    periodo[item['idcampo']+'dalleora1']=rows[item['idcampo']+ 'dalle1'][:2]
                    periodo[item['idcampo']+'dallemin1']=rows[item['idcampo']+ 'dalle1'][2:4]
                if len(rows[item['idcampo']+ 'alle1'])>=4:
                    periodo[item['idcampo']+'alleora1']=rows[item['idcampo']+ 'alle1'][:2]
                    periodo[item['idcampo']+'allemin1']=rows[item['idcampo']+ 'alle1'][2:4]
                if len(rows[item['idcampo']+ 'dalle2'])>=4:                    
                    periodo[item['idcampo']+'dalleora2']=rows[item['idcampo']+ 'dalle2'][:2]
                    periodo[item['idcampo']+'dallemin2']=rows[item['idcampo']+ 'dalle2'][2:4]
                if len(rows[item['idcampo']+ 'alle2'])>=4:                    
                    periodo[item['idcampo']+'alleora2']=rows[item['idcampo']+ 'alle2'][:2]
                    periodo[item['idcampo']+'allemin2']=rows[item['idcampo']+ 'alle2'][2:4]
               
        return periodo

    security.declarePublic('Pax Use', 'getToApproveChiusura')
    def getToApproveChiusura(self,REQUEST=None):
        "Returns a period"

        request=REQUEST
        
        queryParams={}

        if request.has_key('id_pratica'):
            queryParams['id_pratica']=request['id_pratica']

        results=self.sqlGetToApproveChiusura(queryParams)
      
        approve={'giornochiusura':-1}
        approve['mezzagiornata']=''

        for item in results:
            approve['giornochiusura']=item['giornochiusura']
            approve['mezzagiornata']=item['mezzagiornata']
            
        return approve
    

    def getPratica(self,id_pratica=None):
        "Returns periods"

        pratica = self.sqlGetPratica(id_pratica=id_pratica) 

        return pratica


##     security.declarePublic('Pax Use', 'checkPermission')
##     def checkPermission(self,REQUEST=None):
##         "Check Permissions"

        
##         session =  getattr(REQUEST,'SESSION',None)


## ## TODO if is merzi	if not self.portal_membership.isAnonymousUser():
## ##            return 1

##         if not session.has_key('commdata'):
##             raise "Sessione scaduta"
        
##         id_pratica=session['commdata']['id_pratica']

##         return self.checkPermission(REQUEST)
    
    security.declarePublic('Pax Use', 'deletePeriods')
    def deletePeriods(self,REQUEST):
        "Delete periods"

        periodi =  getattr(REQUEST,'periodi')

        id_pratica =  getattr(REQUEST,'id_pratica')        
        
        sql_string = "UPDATE toapproveperiodi set deleted = 1 WHERE "
        for periodo in periodi:
            sql_string = sql_string + " id = '%s'" % periodo
            utils.runQuery(self.getConnection(),sql_string)
            
        REQUEST.RESPONSE.redirect(REQUEST['URL1']+'/view_pratica?id_pratica=' + id_pratica)


    security.declarePublic('Pax Use', 'copyPeriods')
    def copyPeriods(self,REQUEST):
        "copyPeriods"

        id_pratica =  getattr(REQUEST,'id_pratica')        

        periodi = self.sqlGetPeriodi(id_pratica=getattr(REQUEST,'id_pratica',''))
        
	for periodo in periodi:

            if periodo['data_inserimento']==None:
                data_inserimento='NULL'
            else:
                data_inserimento="'"+periodo['data_inserimento'].strftime('%Y/%m/%d')+"'"
                       
            sql_string = "insert into toapproveperiodi (id_pratica, id_attivita,  numero , anno , dal , al , data_inserimento, utente_inserimento,  ludalle1, lualle1, ludalle2, lualle2, madalle1, maalle1, madalle2 ,maalle2, medalle1, mealle1, medalle2, mealle2, gidalle1, gialle1, gidalle2, gialle2, vedalle1, vealle1, vedalle2, vealle2, sadalle1, saalle1, sadalle2, saalle2, dodalle1, doalle1, dodalle2, doalle2 ) VALUES ('%s','%s','%s','%s','%s','%s', %s,'%s', '%s','%s','%s','%s' ,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')" % (periodo['id_pratica'], periodo['id_attivita'], periodo['numero'], periodo['anno'], periodo['dal'], periodo['al'], data_inserimento, periodo['utente_inserimento'], periodo['ludalle1'], periodo['lualle1'], periodo['ludalle2'], periodo['lualle2'], periodo['madalle1'], periodo['maalle1'], periodo['madalle2'] ,periodo['maalle2'], periodo['medalle1'], periodo['mealle1'], periodo['medalle2'], periodo['mealle2'], periodo['gidalle1'], periodo['gialle1'], periodo['gidalle2'], periodo['gialle2'], periodo['vedalle1'], periodo['vealle1'], periodo['vedalle2'], periodo['vealle2'], periodo['sadalle1'], periodo['saalle1'], periodo['sadalle2'], periodo['saalle2'], periodo['dodalle1'], periodo['doalle1'], periodo['dodalle2'], periodo['doalle2'] )

            utils.runQuery(self.getConnection(),sql_string)

        pratica = self.sqlGetPratica(id_pratica=getattr(REQUEST,'id_pratica',''))
        for item in pratica:
            sql_string = "insert into toapprovechiusura (id_pratica, giornochiusura, mezzagiornata ) VALUES ('%s','%s','%s')" % (item['id_pratica'], item['giornochiusura'], item['mezzagiornata'])


        utils.runQuery(self.getConnection(),sql_string)

        REQUEST.RESPONSE.redirect(REQUEST['URL1']+'/view_pratica?id_pratica=' + id_pratica)


    security.declarePublic('Pax Use', 'ComposeDocument')
    def ComposeDocument(self,REQUEST):

        id_pratica=getattr(REQUEST,'id_pratica','')
        session =  getattr(REQUEST,'SESSION',None)
  
        periodi=self.sqlGetToApprovePeriodi(id_pratica=id_pratica)

        filecontent="L'utente %s, relativamente alla pratica %s,  ha comunicato i seguenti orari di apertura annuale||" % (session['nome'],id_pratica)

        pippo=0;
        for periodo in periodi:
            attivita=self.sqlGetAttivita(id_pratica=id_pratica)
            # self.getAttivita(attivita,periodo['id_attivita'])
            filecontent=filecontent + "Attivita: %s ||  Dal: %s Al %s | Lunedi: dalle %s alle %s dalle %s alle %s | Martedi: dalle %s alle %s dalle %s alle %s | Mercoledi: dalle %s alle %s dalle %s alle %s | Giovedi: dalle %s alle %s dalle %s alle %s | Venerdi: dalle %s alle %s dalle %s alle %s | Sabato: dalle %s alle %s dalle %s alle %s | Domenica:  dalle %s alle %s dalle %s alle %s ||" % (self.getAttivita(attivita,periodo['id_attivita']), periodo['dal'], periodo['al'],  periodo['ludalle1'], periodo['lualle1'], periodo['ludalle2'], periodo['lualle2'], periodo['madalle1'], periodo['maalle1'], periodo['madalle2'] ,periodo['maalle2'], periodo['medalle1'], periodo['mealle1'], periodo['medalle2'], periodo['mealle2'], periodo['gidalle1'], periodo['gialle1'], periodo['gidalle2'], periodo['gialle2'], periodo['vedalle1'], periodo['vealle1'], periodo['vedalle2'], periodo['vealle2'], periodo['sadalle1'], periodo['saalle1'], periodo['sadalle2'], periodo['saalle2'], periodo['dodalle1'], periodo['doalle1'], periodo['dodalle2'], periodo['doalle2'])

#       raise filecontent
        return filecontent



    security.declarePublic('Pax Use', 'ComposeTemporanea')
    def ComposeTemporanea(self,REQUEST):
        id_pratica=getattr(REQUEST,'id_pratica','')
        session =  getattr(REQUEST,'SESSION',None)
  
        filecontent="L'utente %s, relativamente alla pratica %s,  ha comunicato la chiusura temporanea" % (session['nome'],id_pratica)

        return filecontent


    security.declarePublic('Pax Use', 'sendComunication')
    def sendComunication(self,REQUEST,RESPONSE):
        "comunicazione semplice"

        save=getattr(REQUEST,'Annulla','')
        id_attivita=getattr(REQUEST,'id_attivita','')
        
        session = REQUEST.SESSION
        if not session.has_key('commdata'):
            raise "Sessione scaduta"
        
        commdata = session['commdata']
        
        id_pratica =  getattr(REQUEST,'id_pratica')
    
        if save=='Annulla':
            RESPONSE.redirect(commdata['send'])
            return 1

        dalgiorno=getattr(REQUEST,'dalgiorno','')
        dalmese=getattr(REQUEST,'dalmese','')        
        algiorno=getattr(REQUEST,'algiorno','')
        almese=getattr(REQUEST,'almese','')
        id_pratica =  getattr(REQUEST,'id_pratica')        


        dal=strptime(dalmese+'/'+dalgiorno+'/'+now().strftime("%Y"),"%m/%d/%Y")
        al=strptime(almese+'/'+algiorno+'/'+now().strftime("%Y"),"%m/%d/%Y")

        if(dal > al):
            raise "Attenzione periodo errato, ricontrollare le date"

        diff=al - dal
        if(diff.day >= 30):
            raise "Attenzione periodo di chiusura maggiore di 30 giorni, richiede autorizzazione"

#        sql_string = "select * from chiusuratemporanea where id_pratica = '%s'" % (id_pratica)
        
#        CNX__.query(sql_string)

        for attivity in id_attivita:
            sql_string = "insert into chiusuratemporanea (id_pratica,dal,al,approved,id_attivita) VALUES ('%s','%s','%s','%s','%s')" % (id_pratica,dal.strftime("%d/%m/%Y"),al.strftime("%d/%m/%Y"),'1',attivity)
            #raise sql_string

            utils.runQuery(self.getConnection(),sql_string)
        
        testo=self.ComposeTemporanea(REQUEST)
        
        REQUEST['oggetto'] = 'Comunicazione Chiusura Temporanea'
        REQUEST['send'] = session['commdata']['send']
        REQUEST['id_passo'] = session['commdata']['id_passo']
        paramstring='/?oggetto='+'Comunicazione Orario Annuale di apertura' + '&send=' + session['commdata']['send']+'&id_passo='+session['commdata']['id_passo']+'&id_pratica='+id_pratica + '&testo='+ testo

            
        REQUEST.RESPONSE.redirect(self.getPaxPath(REQUEST)+paramstring)
        
        return 1
        
        
    security.declarePublic('Pax Use', 'inviaDati')
    def inviaDati(self,REQUEST=None):
        "Invia i Dati"

        if not (self.validSession(REQUEST) and self.checkPermission(REQUEST)):
            raise 'Sessione scaduta'
        
        session = REQUEST.SESSION

        submit=getattr(REQUEST,'submit','')
    
        if submit=='Cancella':
            self.deletePeriods(REQUEST)


        if submit=='Copia':
            self.copyPeriods(REQUEST)


        if submit=='Approva':
            self.approveOrari(REQUEST)


        if submit=='Invia Comunicazione':

            cf=session['commdata']['cf']
            
            testo=self.ComposeDocument(REQUEST)

            data_inserimento = now().strftime("%d/%m/%Y")

            anno = now().strftime("%Y")

            id_pratica=getattr(REQUEST,'id_pratica','')
            giornochiusura=getattr(REQUEST,'giornochiusura','')
            mezzagiornata=getattr(REQUEST,'mezzagiornata','')        

            
##             fromadd="web@comune.rivadelgarda.tn.it"
##             toadd="coloriomauro@comune.rivadelgarda.tn.it"
##             oggetto=""
##             testo = "In data %s l'utente %s ha comunicato l'orario annuale di apertura per la pratica %s" % (now().strftime('%d/%m/%Y'), cf, id_pratica)

##             text_attachment = MIMEText(testo)
##             outer = MIMEBase('multipart', 'mixed')
##             outer.attach(text_attachment)
            
##             outer['From'] = fromadd
##             outer['To'] = toadd
##             outer['Subject'] = 'Comunicazione orario annuale'
            
##             server=smtplib.SMTP('localhost')
##             server.sendmail(fromadd,toadd,str(outer))
##             server.quit()



            REQUEST['oggetto'] = 'Comunicazione Orario Annuale di apertura'
            REQUEST['send'] = session['commdata']['send']
            REQUEST['id_passo'] = session['commdata']['id_passo']
            paramstring='/?oggetto='+'Comunicazione Orario Annuale di apertura' + '&send=' + session['commdata']['send']+'&id_passo='+session['commdata']['id_passo']+'&id_pratica='+id_pratica + '&testo='+ testo

            sql_string = "delete from chiusura where id_pratica = '%s'" % (id_pratica)

            utils.runQuery(self.getConnection(),sql_string)          

            sql_string = "INSERT into chiusura (id_pratica, anno, giornochiusura, mezzagiornata, data_inserimento, utente_inserimento ) VALUES ('%s' , '%s',  '%s', '%s', '%s', '%s')" % (id_pratica, anno, giornochiusura, mezzagiornata, data_inserimento, cf)

            utils.runQuery(self.getConnection(),sql_string)                      

            REQUEST.RESPONSE.redirect(self.getPaxPath(REQUEST)+paramstring)
            
#        raise session

    security.declarePublic('Pax Use', 'getPaxPath')
    def getPaxPath(self,REQUEST):
        "save Session"
        session =  REQUEST.SESSION

        if session != None:
            return session['commdata']['ref']
        else:
           #return REQUEST['URL1']
            return '../pratiche/listpratiche'




    security.declarePublic('Pax Use', 'saveSession')
    def saveSession(self,REQUEST):
        "save Session"

        session=REQUEST.SESSION

        send=getattr(REQUEST,'send',None)
        esterno=getattr(REQUEST,'esterno',None)
        #    raise REQUEST    
        
        if ((send != None) or (esterno != None)):
            commdata = {}
            commdata['cf']=getattr(REQUEST,'cf','')
            commdata['ripetitivo']=getattr(REQUEST,'ripetitivo','')
            commdata['id_pratica']=getattr(REQUEST,'id_pratica','')
            commdata['id_passo']=getattr(REQUEST,'id_passo','')
            commdata['send']=getattr(REQUEST,'send','')
            commdata['ref']=getattr(REQUEST,'ref','')

            if esterno != None:
                commdata['esterno']=esterno            
            session['commdata']=commdata

#        raise REQUEST
        return REQUEST    

    security.declarePublic('Pax Use', 'savePeriod')
    def savePeriod(self,REQUEST,RESPONSE=None):
        "Save a period"

        save=getattr(REQUEST,'Annulla','')

        session = REQUEST.SESSION
        id_pratica =  getattr(REQUEST,'id_pratica')
        
        if save=='Annulla':
            RESPONSE.redirect(REQUEST['URL1']+ '/view_pratica?id_pratica='+id_pratica)
            return 1
        
        anno = now().strftime("%Y")

        cf=session['commdata']['cf']
        data_inserimento = now().strftime("%d/%m/%Y")
        
        id=getattr(REQUEST,'id','')
        id_pratica=getattr(REQUEST,'id_pratica','')
        id_attivita=getattr(REQUEST,'id_attivita','')
        dalgiorno=getattr(REQUEST,'dalgiorno','')
        dalmese=getattr(REQUEST,'dalmese','')        
        algiorno=getattr(REQUEST,'algiorno','')
        almese=getattr(REQUEST,'almese','')
        dal=dalgiorno+'/'+dalmese+'/2000'
        al=algiorno+'/'+almese+'/2000'        

        dalleora1 =  getattr(REQUEST,'dalleora1')
        dallemin1 =  getattr(REQUEST,'dallemin1')        
        alleora1 =  getattr(REQUEST,'alleora1')
        allemin1 =  getattr(REQUEST,'allemin1')        
        dalleora2 =  getattr(REQUEST,'dalleora2')
        dallemin2 =  getattr(REQUEST,'dallemin2')        
        alleora2 =  getattr(REQUEST,'alleora2')
        allemin2 =  getattr(REQUEST,'allemin2')


    
        if getattr(REQUEST,'modifica','')!='1':            


            # inserisce un nuovo periodo

            # calcolo il numero successivo 
            sql_string = "select coalesce(max(a.numero),0) from toapproveperiodi a, attivita b where a.id_attivita = b.id \
            and a.id_pratica = '%s' and  a.id_attivita = '%s'  and a.anno = '%s' and deleted is NULL" % (id_pratica, id_attivita, anno)
            
            items, results = utils.runQuery(self.getConnection(),sql_string)          

#            raise sql_string
            
            
            for result in results:
                numero = int(result[0])+1

            
            sql_string = "insert into toapproveperiodi (id_pratica, id_attivita,  numero , anno , dal , al , data_inserimento, utente_inserimento,  ludalle1, lualle1, ludalle2, lualle2, madalle1, maalle1, madalle2 ,maalle2, medalle1, mealle1, medalle2, mealle2, gidalle1, gialle1, gidalle2, gialle2, vedalle1, vealle1, vedalle2, vealle2, sadalle1, saalle1, sadalle2, saalle2, dodalle1, doalle1, dodalle2, doalle2 ) VALUES ('%s','%s','%s','%s','%s','%s', '%s','%s' " % (id_pratica, id_attivita, numero, anno, dal, al, data_inserimento, cf )

            i = 0
            for item in self.getDaysOfWeek():
                sql_string += ", '" + dalleora1[i] + dallemin1[i] + "'"
                sql_string += ", '" + alleora1[i] + allemin1[i] + "'"
                sql_string += ", '" + dalleora2[i] + dallemin2[i] + "'"
                sql_string += ", '" + alleora2[i] + allemin2[i] + "'"             
                i=i+1

            sql_string += ")"
        else:
            # modifca un periodo esistente

            sql_string = "update toapproveperiodi set id_attivita= '%s' ,  dal = '%s' , al = '%s', data_inserimento = '%s' , utente_inserimento = '%s'" % (id_attivita, dal, al, data_inserimento, cf)

            i = 0
            for item in self.getDaysOfWeek():
                sql_string += "," + item['idcampo'] + 'dalle1'+  "='" + dalleora1[i] + dallemin1[i] + "'"
                sql_string += "," + item['idcampo'] + 'alle1'+  "='" + alleora1[i] + allemin1[i] + "'"
                sql_string += "," + item['idcampo'] + 'dalle2'+  "='" + dalleora2[i] + dallemin2[i] + "'"
                sql_string += "," + item['idcampo'] + 'alle2'+  "='" + alleora2[i] + allemin2[i] + "'"             
                i=i+1

            sql_string += " where id_pratica = '%s' and id = '%s'" % (id_pratica, id )

#        raise sql_string

        utils.runQuery(self.getConnection(),sql_string)                                                               
           
        RESPONSE.redirect(REQUEST['URL1']+'/view_pratica?id_pratica='+id_pratica)

    security.declarePublic('Pax Use', 'doSqlGetPratiche')
    def doSqlGetPratiche(self,REQUEST=None,RESPONSE=None):
        request = REQUEST
        queryParams={}

        if request.has_key('insegna'):
            queryParams['insegna']='%'+request['insegna'].upper() + '%'

        if request.has_key('attivita'):
            if len(request['attivita']) > 0:
                queryParams['id_attivita']=request['attivita']

        results = self.sqlGetPratiche(queryParams)

        return results
        
        "CopyValues"


    security.declarePublic('Pax Use', 'CopyValues')
    def CopyValues(self,REQUEST=None):
        "CopyValues"

        string = '\n\nfunction CopyValues(form) {\n'
               
        for item in self.getDaysOfWeek():
            string += 'form.' + item['idcampo'] + 'dalleora1.value = form.ludalleora1.value;\n'
            string += 'form.' + item['idcampo'] + 'dallemin1.value = form.ludallemin1.value;\n'
            string += 'form.' + item['idcampo'] + 'alleora1.value = form.lualleora1.value;\n'
            string += 'form.' + item['idcampo'] + 'allemin1.value = form.luallemin1.value;\n'
            string += 'form.' + item['idcampo'] + 'dalleora2.value = form.ludalleora2.value;\n'
            string += 'form.' + item['idcampo'] + 'dallemin2.value = form.ludallemin2.value;\n'
            string += 'form.' + item['idcampo'] + 'alleora2.value = form.lualleora2.value;\n'
            string += 'form.' + item['idcampo'] + 'allemin2.value = form.luallemin2.value;\n\n\n'


        string += '\n}\n'
        
        return string



    security.declarePublic('Pax Use', 'sqlGetPratica')
    def sqlGetPratica(self,id_pratica=None,REQUEST=None):
        "sqlGetPeriodi"

        sqlCommand = "select a.id_pratica, a.insegna ,  a.civico , a.sub ,\n\
        a.tipoalbergo , a.camere , a.letti , a.tipomensa, a.classifica , a.tipoc , a.attivitaprevalente ,\n\
        b.anno ,    b.giornochiusura , b.mezzagiornata, c.nomevia, c.zona, c.frazione\n\
        from ( commercio a left join chiusura b on a.id_pratica = b.id_pratica ) \n\
        inner join vie c on a.idvia = c.id\n\
        where a.id_pratica='%s'" % (id_pratica)

        results=utils.runMappedQuery(self.getConnection(),sqlCommand)

        return results



    security.declarePublic('Pax Use', 'sqlGetPeriodi')
    def sqlGetPeriodi(self,id_pratica=None,REQUEST=None):
        "sqlGetPeriodi"

        sqlCommand = "select a.data_inserimento, a.utente_inserimento,\n\
        a.id_pratica ,  a.id_attivita, a.id, a.numero , a.anno, a.dal ,a.al ,\n\
        a.ludalle1, a.lualle1, a.ludalle2, a.lualle2,\n\
        a.madalle1, a.maalle1, a.madalle2, a.maalle2,\n\
        a.medalle1, a.mealle1, a.medalle2, a.mealle2,\n\
        a.gidalle1, a.gialle1, a.gidalle2, a.gialle2,\n\
        a.vedalle1, a.vealle1, a.vedalle2, a.vealle2,\n\
        a.sadalle1, a.saalle1, a.sadalle2, a.saalle2,\n\
        a.dodalle1, a.doalle1, a.dodalle2, a.doalle2,\n\
        b.descrizione\n\
        from periodi a, attivita b \n\
        where a.id_attivita = b.id\n\
        and a.deleted IS NULL\n\
        and a.id_pratica = '%s'" % (id_pratica)
        
        results=utils.runMappedQuery(self.getConnection(),sqlCommand)

        return results



    security.declarePublic('Pax Use', 'sqlGetToApprovePeriodi')
    def sqlGetToApprovePeriodi(self,id_pratica=None,REQUEST=None):

        sqlCommand = "select a.id_pratica ,  a.id_attivita, a.id, a.numero , a.anno, a.dal ,a.al , \n\
        a.ludalle1, a.lualle1, a.ludalle2, a.lualle2,\n\
        a.madalle1, a.maalle1, a.madalle2, a.maalle2,\n\
        a.medalle1, a.mealle1, a.medalle2, a.mealle2,\n\
        a.gidalle1, a.gialle1, a.gidalle2, a.gialle2,\n\
        a.vedalle1, a.vealle1, a.vedalle2, a.vealle2,\n\
        a.sadalle1, a.saalle1, a.sadalle2, a.saalle2,\n\
        a.dodalle1, a.doalle1, a.dodalle2, a.doalle2,\n\
        b.descrizione, a.approvato, a.data_approvazione,\n\
        a.data_inserimento, a.utente_inserimento, a.utente_approvazione\n\
        from toapproveperiodi a, attivita b \n\
        where a.id_attivita = b.id\n\
        and a.deleted IS NULL\n\
        and a.id_pratica = '%s'" % (id_pratica)

        results=utils.runMappedQuery(self.getConnection(),sqlCommand)

        return results
        

    security.declarePublic('Pax Use', 'sqlGetPeriodo')
    def sqlGetPeriodo(self,queryParams,REQUEST=None):

        sqlCommand = "select a.id_pratica ,  a.id_attivita, a.id, a.numero , a.anno, a.dal ,a.al , \n\
        a.ludalle1, a.lualle1, a.ludalle2, a.lualle2,\n\
        a.madalle1, a.maalle1, a.madalle2, a.maalle2,\n\
        a.medalle1, a.mealle1, a.medalle2, a.mealle2,\n\
        a.gidalle1, a.gialle1, a.gidalle2, a.gialle2,\n\
        a.vedalle1, a.vealle1, a.vedalle2, a.vealle2,\n\
        a.sadalle1, a.saalle1, a.sadalle2, a.saalle2,\n\
        a.dodalle1, a.doalle1, a.dodalle2, a.doalle2,\n\
        a.data_inserimento, a.utente_inserimento,\n\
        b.descrizione\n\
        from periodi a, attivita b \n\
        where  a.id_attivita = b.id\n\
        and id_pratica = '%(id_pratica)s'\n\
        and a.id = '%(id)s'" % queryParams

        results=utils.runMappedQuery(self.getConnection(),sqlCommand)

        return results
        

    security.declarePublic('Pax Use', 'sqlGetToApprovePeriodo')
    def sqlGetToApprovePeriodo(self,queryParams,REQUEST=None):

        sqlCommand = "select a.id_pratica ,  a.id_attivita, a.id, a.numero , a.anno, a.dal ,a.al , \n\
        a.ludalle1, a.lualle1, a.ludalle2, a.lualle2,\n\
        a.madalle1, a.maalle1, a.madalle2, a.maalle2,\n\
        a.medalle1, a.mealle1, a.medalle2, a.mealle2,\n\
        a.gidalle1, a.gialle1, a.gidalle2, a.gialle2,\n\
        a.vedalle1, a.vealle1, a.vedalle2, a.vealle2,\n\
        a.sadalle1, a.saalle1, a.sadalle2, a.saalle2,\n\
        a.dodalle1, a.doalle1, a.dodalle2, a.doalle2,\n\
        a.data_approvazione, utente_approvazione, b.descrizione\n\
        from toapproveperiodi a, attivita b \n\
        where a.id_attivita = b.id\n\
        and id_pratica = '%(id_pratica)s'\n\
        and a.id = '%(id)s'" % queryParams

        results=utils.runMappedQuery(self.getConnection(),sqlCommand)

        return results


    security.declarePublic('Pax Use', 'sqlGetAttivita')
    def sqlGetAttivita(self,id_pratica=None,REQUEST=None):

        sqlCommand = "select a.id, a.descrizione from attivita a, commercioattivita b , commercio c \n\
        where a.id = b.idattivita and\n\
        c.id_pratica = b.id_pratica\n\
        and c.id_pratica = '%s'" % (id_pratica)
       
        results=utils.runMappedQuery(self.getConnection(),sqlCommand)

        return results



    security.declarePublic('Pax Use', 'sqlGetPratiche')
    def sqlGetPratiche(self,insegna=None,id_attivita=None, REQUEST=None):


        sql_string = 'select distinct a.id_pratica, a.insegna ,  a.civico , a.sub , \n\
        a.tipoalbergo , a.camere , a.letti , a.tipomensa, a.classifica , a.tipoc , a.attivitaprevalente ,\n\
        b.anno ,    b.giornochiusura , b.mezzagiornata, c.nomevia, c.zona, c.frazione\n\
        from ( commercio a left join chiusura b on a.id_pratica = b.id_pratica ) \n\
        inner join vie c on a.idvia = c.id\n\
        inner join commercioattivita d on a.id_pratica = d.id_pratica\n\
        where insegna like \n\
        <dtml-sqltest insegna type="string" op="like" column="upper(a.insegna)" optional>\n\
        <dtml-and> \n\
        <dtml-sqltest id_attivita type="string" op="eq" column="d.idattivita" optional>\n\
        </dtml-sqlgroup>\n'
        

    security.declarePublic('Pax Use', 'sqlGetToApproveChiusura')
    def sqlGetToApproveChiusura(self,queryParams=None,REQUEST=None):
        "sqlGetToApproveChiusura"
        
        sqlCommand = "select * from toapprovechiusura where id_pratica='%(id_pratica)s'" % (queryParams)

        results=utils.runMappedQuery(self.getConnection(),sqlCommand)

        return results



manage_addCommercioForm = DTMLFile('template/manage_addCommercioForm', globals())

def manage_addCommercioAction(self, id, RESPONSE=None):
    "Add a Commercio Application to a folder."
    ob = Commercio(id)
    self._setObject(id, ob)
#    ob = self._getOb(id)
#    tf = MountedTemporaryFolder('temp_folder','Temporary Folder')
#    ob._setObject('temp_folder', tf)

# Aggiunta connessione DB
# Commentato, dovrebbe essercene uno generale
#    ob.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection('dbcnx', 'dbcnx', 'dbname=pratiche user=coloriomauro')

# Aggiunti Metodi SQL 
#    id_sql = "sqlGetPratica"
##     sql_string = 'select a.id_pratica, a.insegna ,  a.civico , a.sub ,\n\
##     a.tipoalbergo , a.camere , a.letti , a.tipomensa, a.classifica , a.tipoc , a.attivitaprevalente ,\n\
##     b.anno ,    b.giornochiusura , b.mezzagiornata, c.nomevia, c.zona, c.frazione\n\
##     from ( commercio a left join chiusura b on a.id_pratica = b.id_pratica ) \n\
##     inner join vie c on a.idvia = c.id\n\
##     where a.id_pratica=<dtml-sqlvar id_pratica type=int>'
##     ob.temp_folder.manage_addProduct['ZSQLMethods'].manage_addZSQLMethod(id_sql, 'dbcnx', 'dbcnx', 'id_pratica=None', sql_string)


    RESPONSE.redirect('manage_main')
