/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSTEXTBOX_H
#define PAPYRUSTEXTBOX_H

#include <papyrus/drawable.h>

namespace Papyrus {

typedef enum HJustification {HJUSTIFY_LEFT, HJUSTIFY_RIGHT, HJUSTIFY_CENTER, HJUSTIFY_FULL} HJustification;

typedef enum VJustification {VJUSTIFY_TOP, VJUSTIFY_BOTTOM, VJUSTIFY_CENTER, VJUSTIFY_FULL} VJustificantion;

/**
 * @author Rick L Vinyard Jr
 */
class Textbox : public Drawable
{
public:
  Textbox(double x=0.0, double y=0.0, double w=0.0, double h=0.0);

  ~Textbox();

  const std::string& get_text();
  void set_text(const std::string);

  HJustification get_hjustification();
  void set_hjustification(HJustification hj);

  VJustificantion get_vjustification();
  void set_vjustification(VJustificantion vj);

protected:
  std::string m_text;
  HJustification m_hjustification;
  VJustification m_vjustification;
  double m_width, m_height;

  virtual void draw_item(cairo_t* cairo);

  virtual void on_xywh_changed();

};

}

#endif
