/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "shape.h"

using namespace Papyrus;

Shape::Shape(Pattern fill, Pattern outline)
 : Drawable()
{
}


Shape::~Shape()
{
}


void Shape::draw(cairo_t* cairo)
{
  if (m_fill) {
  draw_shape(cairo);
  m_fill.render(cairo);
  cairo_fill(cairo);
  }

  if (m_outline) {
    draw_shape(cairo);
    m_outline.render(cairo);
    cairo_stroke(cairo);
  }
}

void Shape::set_fill( Pattern fill )
{
  m_fill = fill;
  on_changed(RENDER_PATTERN);
}

void Shape::set_outline( Pattern outline )
{
  m_outline = outline;
  on_changed(RENDER_PATTERN);
}

void Shape::set_fill( double r, double g, double b, double a )
{
  m_fill.set_color(r, g, b, a);
  on_changed(RENDER_PATTERN);
}

void Shape::set_outline( double r, double g, double b, double a )
{
  m_outline.set_color(r, g, b, a);
  on_changed(RENDER_PATTERN);
}

