/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSREGULARPOLYGON_H
#define PAPYRUSREGULARPOLYGON_H

#include <papyrus/polygon.h>

namespace Papyrus {

/**
@author Rick L Vinyard Jr
*/
class RegularPolygon : public Polygon
{
public:
  typedef enum Style {ZERO_VERTEX, ZERO_APOTHEM};

    RegularPolygon(unsigned int sides=3, double radius=1.0, unsigned int style=ZERO_VERTEX);

    ~RegularPolygon();

    unsigned int get_sides();

    void set_sides(unsigned int s);

    double get_radius();
    void set_radius(double r);
    void set_sides_radius(unsigned int s, double r);

    double get_edge();
    void set_edge(double e);
    void set_sides_edge(unsigned int s, double e);

    double get_apothem();
    void set_apothem(double a);
    void set_sides_apothem(unsigned int s, double a);

    unsigned int get_style();
    void set_style(unsigned int);

  protected:
    unsigned int m_sides;
    double m_radius;
    unsigned int m_style;

    void on_regularpolygon_changed();

    void create_vertices();

};

}

#endif
