/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSRECTANGLE_H
#define PAPYRUSRECTANGLE_H

#include <papyrus/shape.h>

namespace Papyrus {

/**
@author Rick L Vinyard Jr
*/
class Rectangle : public Shape
{
public:
  Rectangle(double w=0.0, double h=0.0);
  ~Rectangle();

  double get_width();
  double get_height();

  void get_width_height(double& w, double& h);

  int set_width(double w);
  int set_height(double h);
  int set_width_height(double w, double h);
  int set_xywh(double x, double y, double w, double h);

  virtual void draw_shape(cairo_t* cairo);

protected:
  double m_width, m_height;

  virtual void on_changed(int i);

  private:
    void on_changed_proxy(int i);

};

}

#endif
