/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "rectangle.h"

using namespace Papyrus;

Rectangle::Rectangle(double w, double h):
        Shape(),
        m_width(w),
m_height(h) {
}

Rectangle::~Rectangle() {}

double Rectangle::get_width() {
    return m_width;
}

double Rectangle::get_height() {
    return m_height;
}

void Rectangle::get_width_height(double& w, double& h) {
    w = m_width;
    h = m_height;
}

int Rectangle::set_width(double w) {
    if (m_width != w) {
        m_width = w;
        on_changed(RENDER_WIDTH);
        return RENDER_WIDTH;
    }
    return 0;
}

int Rectangle::set_height(double h) {
    if (m_height != h) {
        m_height = h;
        on_changed(RENDER_HEIGHT);
        return RENDER_HEIGHT;
    }
    return 0;
}

int Rectangle::set_width_height(double w, double h) {
    int which = 0;
    if (m_width != w) {
        m_width = w;
        which |= RENDER_WIDTH;
    }
    if (m_height != h) {
        m_height = h;
        which |= RENDER_HEIGHT;
    }
    if (which)
        on_changed(which);
    return which;
}

int Rectangle::set_xywh( double x, double y, double w, double h )
{
  int which = 0;
  if (m_x != x) {
    m_x = x;
    which |= RENDER_X;
  }
  if (m_y != y) {
    m_y = y;
    which |= RENDER_Y;
  }
  if (m_width != w) {
    m_width = w;
    which |= RENDER_WIDTH;
  }
  if (m_height != h) {
    m_height = h;
    which |= RENDER_HEIGHT;
  }
  if (which)
    on_changed(which);
  return which;
}

void Rectangle::draw_shape(cairo_t* cairo) {
    cairo_rectangle (cairo, 0.0, 0.0, m_width, m_height);
}

void Rectangle::on_changed(int i) {
    m_bbox.set_xywh(0.0, 0.0, m_width, m_height);
    Drawable::on_changed(i|RENDER_BBOX);
}

void Rectangle::on_changed_proxy(int i) {
    on_changed(i);
}

