/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "pattern.h"

using namespace Papyrus;

Pattern::Pattern()
 : Renderable(),
 m_pattern(NULL)
{
}

Pattern::Pattern( double r, double g, double b)
{
  set_color(r, g, b);
}

Pattern::Pattern( double r, double g, double b, double a )
{
  set_color(r, g, b, a);
}

Pattern::~Pattern()
{
}

void Pattern::render( cairo_t * cairo )
{
  if (m_pattern != NULL)
    cairo_set_source(cairo, m_pattern);
}

void Pattern::set_color( double r, double g, double b )
{
  m_pattern = cairo_pattern_create_rgb(r, g, b);
}

void Pattern::set_color( double r, double g, double b, double a )
{
  m_pattern = cairo_pattern_create_rgba(r, g, b, a);
}

