/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSGROUP_H
#define PAPYRUSGROUP_H

#include <list>
#include <map>
#include <vector>

#include <papyrus/drawable.h>

namespace Papyrus {

/**
 * This is the base class for all group types and allows a rooted rendering tree to be
 * defined.
 *
 *
 *
 * @author Rick L Vinyard Jr
 */
class Group : public Drawable {
public:
    typedef std::list<Drawable*> Children;

    friend class Canvas;

    Group();
    Group(Group& parent);

    virtual ~Group();

    Group* get_parent();
    bool set_parent(Group& parent);


    bool add(Drawable& item);
    bool remove(Drawable& object);
    bool clear();

    bool raise(Drawable& item);
    bool raise_to_top(Drawable& item);
    bool lower(Drawable& item);
    bool lower_to_bottom(Drawable& item);

//     virtual std::vector<Item*> pick(cairo_t* cairo, double x, double y, unsigned depth=1);

    virtual Drawable* pick(double x, double y);

protected:
    Group* m_parent;
    // maintaining both items as list for drawing order and connections for quick access
    Children m_children;
    typedef std::map<Drawable*, sigc::connection> Connections;
    Connections m_connections;
    Connections m_child_connections;

    void on_child_changed(Object* child, int changed);
    void on_child_need_redraw(double x, double y, double w, double h);
    virtual void draw(cairo_t* cairo);

    void rebuild_bbox();

};

};

#endif
