/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSBOXEDGROUP_H
#define PAPYRUSBOXEDGROUP_H

#include <papyrus/group.h>

namespace Papyrus {

/**
@author Rick L Vinyard Jr
*/
class BoxedGroup : public Group
{
public:
    BoxedGroup();
    BoxedGroup(Group& parent);

    ~BoxedGroup();

    void tie(BBox& bounding, int dimensions=BBOX_X|BBOX_Y|BBOX_WIDTH|BBOX_HEIGHT);
    void untie();

    void set_tied_dimensions(int dimensions);

  protected:
    BBox* m_bound;
    int m_tied_dimensions;
    sigc::connection m_tied_connection;

    void on_tied_bbox_changed(Object*, int dimension);

};

}

#endif
