/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>
#include <libpandora/common_options.h>
#include <pandora_components/valuepacket.h>

#include "watchcomponent.h"

component_export(WatchComponent, Packet, Packet);

WatchComponent::WatchComponent(void) 
  : func(0), nbfail(0), lim_eval(0), lim_fail(1)
{
  registerComplexOption(symbol_option, "func", &func);
  registerOption("thresold", &lim_eval);
  registerOption("limit", &lim_fail);
}

bool WatchComponent::add(Packet *pkt) 
{
  if ((func != NULL)
      && ((*func)(pkt) > lim_eval)) { 
    failure();
  } else {
    nbfail = 0;
  }

  cleanPacket(pkt);  
  return false;
}

bool WatchComponent::prepare(void) 
{
  //pandora_debug("[watch prepare]");
  failure();
  return false;
}

void WatchComponent::cleanup(void) 
{
  func = NULL; 
  nbfail = 0; 
  lim_fail = 0; 
  lim_eval = 0;
}

void WatchComponent::failure(void) 
{
  //pandora_debug("[watch failure]");
  ++nbfail;
  if (nbfail >= lim_fail) {
    push(new TextValuePacket("FAILURE!"));
    nbfail = 0;
  } 
}


