/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/usleep.h>
	   }

#include "wallclockcomponent.h"
#include <libpandora/pandora.h>
#include <libpandora/timersupervisor.h>

component_export(WallClockComponent,,);

int WallClockComponent::init(void)
{
  if (timer != NULL) return ERROR_FILENO;

  pandora_assert(pandora != NULL);
  if (nextStack == NULL) return ERROR_FILENO;
  
  timer = (nextStack)->getTimerSupervisor();
  pandora_assert(timer != NULL);

  if (gettimeofday(&tv, NULL) < 0) {
    pandora_perror("gettimeofday");
  }

  return THREADED_FILENO;
}

bool WallClockComponent::process(void) 
{
  static int i = 1000000 * freq;
  static int t = i;
  static int d = 0;
  static timeval cur_tv = tv;

#if 0
  pandora_debug(cur_tv << " / " << tv 
		<< " (" << i << " / " << t << " / " << d << ")");
#endif
  usleep(t);
  timer->wall(cur_tv.tv_sec);
  tv.tv_sec += freq;
  if (gettimeofday(&cur_tv, NULL) < 0) {
    pandora_perror("gettimeofday");
  }
  d = (cur_tv.tv_sec - tv.tv_sec) * 1000000
    + (cur_tv.tv_usec - tv.tv_usec);
  i -= d / 8;
  t = pandora_max(i - d / 2, 0);

  return false;
}

void WallClockComponent::cleanup(void) 
{ 
  nextStack = NULL;
  timer = NULL; 
}
