/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

#include "w2nrequestcomponent.h" 
#include <pandora_components/w2npacket.h> 
#include <pandora_components/requestpacket.h> 

component_export(W2NRequestComponent, W2NPacket+, RequestPacket);

bool W2NRequestComponent::add(Packet *pkt) 
{
  locatePacket0(W2NPacket, w2np, pkt);
  if (w2np == NULL) {
    cleanPacket(pkt);
    return false;
  }

  int len = w2np->write(buf, MAX_PACKET_SIZE, 0);
  if (len > 0) {
    RequestPacket *rp = new RequestPacket(w2np->addr, w2np->port, 
					&(w2np->timeStamp));
    (rp->req).growUp(MAX_PACKET_SIZE);
    (rp->req).write(buf, len);
    push(rp);
  }

  cleanPacket(pkt);
  return false;
} 

