/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef W2N_FILTER_COMPONENT_H
#define W2N_FILTER_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <libpandora/map.h>
#include <libpandora/text.h>
#include <libpandora/smart_ptr.h>
#include <libpandora/pandora_limits.h>

class FSEventPacket;
class W2NPacket;

class W2NFilterComponent : public Component {
private:
  typedef smart_ptr<text> text_ptr_t;
  Map<text_ptr_t, W2NPacket *> notifications;

public:
  component_init(W2NFilterComponent, 1);
  W2NFilterComponent(void);
  virtual ~W2NFilterComponent(void) { }

  bool add(FSEventPacket *);
  bool add(W2NPacket *);

  virtual void cleanup(void);

private:
  bool match(const FSEventPacket *fsep, const text &url);
};

#endif /* W2N_FILTER_COMPONENT_H */
