/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <pandora_components/valuepacket.h>
#include <libpandora/pandorakey.h>
#include <libpandora/algo_funcs.h>

packet_export(IntValuePacket,);
packet_export(FloatValuePacket,);
packet_export(BoolValuePacket,);
packet_export(TextValuePacket,);

extern_pandora(algo, bool, valint, (Packet *pkt, PandoraKey *k))
{
  locatePacket0(IntValuePacket, vp, pkt);
  if (vp == NULL) return false;
  k->set(vp->val);
  return true;
}

extern_pandora(hash, int, hvalint, (Packet *pkt))
{
  locatePacket0(IntValuePacket, vp, pkt);
  if (vp == NULL) return -1;
  return vp->val + 1;
}

