/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef UDP_PACKET_H
#define UDP_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <pandora_components/udp.h>
	   }

#include <libpandora/packet.h>

class IPPacket;
class TCPPacket;


class UDPPacket : public Packet {
public:
  u_short 	sport;
  u_short 	dport;

  u_short 	length;

public:
  packet_init(UDPPacket, 1);

  UDPPacket(IPPacket *);
  UDPPacket(TCPPacket *);
  UDPPacket(const UDPPacket& x);
  UDPPacket& operator= (const UDPPacket& x);
  virtual ~UDPPacket(void) {}

  bool reject(void) { return (length == 0 ); }
  virtual void print(ostream *) ;
  
  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

#endif /* UDP_PACKET_H */
