/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef TRACE_COMPONENT_H
#define TRACE_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
	   }

#include <iostream>
#include <libpandora/packet.h>
#include <libpandora/ring.h>

#include <libpandora/component.h>

class TraceComponent : public Component {
  char *tag;
  bool life, ts;

public:
  component_init(TraceComponent, 1);
  TraceComponent(void) : tag(NULL), life(false), ts(false) {
    registerOption("tag", &tag);
    registerOption("life", &life);
    registerOption("ts", &ts);
  }
  virtual ~TraceComponent(void) {}
  virtual bool add(Packet *);
};


class CountComponent : public Component {
  int count;

public:
  component_init(CountComponent, 1);
  CountComponent(void) : count(0) { registerOption("count", &count); }
  virtual ~CountComponent(void) {}

  virtual bool add(Packet *pkt);
  virtual void cleanup(void);
};

class TimeComponent : public Component {
  timeval start, end;
  
public:
  component_init(TimeComponent, 1);
  TimeComponent(void) { start.tv_sec = 0; }
  virtual ~TimeComponent(void) { }

  virtual bool add(Packet *pkt);
  virtual void setup(void);
  virtual void cleanup(void);
};

class ClockComponent : public Component {
  clock_t start, end;
  
public:
  component_init(ClockComponent, 1);
  ClockComponent(void) { start = 0; }
  virtual ~ClockComponent(void) { }

  virtual bool add(Packet *pkt);
  virtual void setup(void);
  virtual void cleanup(void);
};

class FlowRateComponent : public Component {
  int rate;
  int interval;
  int window;

  time_t last;
  int count;
  Ring<int> ring;

public:
  component_init(FlowRateComponent, 1);
  FlowRateComponent(void);
  virtual ~FlowRateComponent(void) {}

  virtual bool add(Packet *pkt);
  virtual void setup(void);
  virtual void cleanup(void);
};

#endif /* TRACE_COMPONENT_H */
