/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "tcpreqflowcomponent.h"
#include <pandora_components/tcppacket.h>
#include <pandora_components/udppacket.h>
#include <pandora_components/ippacket.h>

component_export(TCPReqFlowComponent, TCPPacket, UDPPacket);

bool TCPReqFlowComponent::add(Packet *pkt)
{
  /// XXX need complete rework... XXX //
  TCPPacket *tcpp = static_cast<TCPPacket *>(pkt);
  locatePacket(IPPacket, ipp, tcpp);
  pandora_assert(ipp != NULL);

  tcpp->refer();

  size_t offset = 0;
  u_int32_t segFinSeq = 0;
  bool eof = tcpp->eof;
    
  if ((tcpp->length == 0) && !(tcpp->flags & (TH_SYN|TH_RST|TH_FIN)))
    goto finished;

  if (!synch) synch = (tcpp->flags & TH_SYN);
  if (!synch) goto finished;
    
  segFinSeq = SEQ_ADD(tcpp->seq, tcpp->length);
    
  while (offset < tcpp->length) {
    if (started == false) {
      if (udpp != NULL) dispatch();
        
      u_short reqlen = (ipp->_data).getShort();
      offset += 2;
      int totlen = offset + reqlen;
      finSeq = SEQ_ADD(tcpp->seq, totlen);

      udpp = new UDPPacket(tcpp);
      udpp->length = reqlen;
      //pandora_debug(reqlen);
      toRead = snapLen;
      // XXX continue?
    }
    
    int offToEnd = SEQ_SUB(finSeq, tcpp->seq);
    size_t utilLen = pandora_min((int)offToEnd, 
				 (int)(tcpp->length - offset));

    locatePacket(IPPacket, ipp2, udpp);
    if (!started) { // first TCP packet in UDP ?
      (ipp2->_data).growUp(snapLen);
      started = true;
    } else {
      if (offToEnd < 0) { // We missed something !
	offset = tcpp->length;
	dispatch();
      } else {
	if ((toRead > 0) && (utilLen > 0)) {
	  size_t bytes = pandora_min((int)toRead, (int)utilLen);
	  (ipp2->_data).write(ipp->data(), bytes);
	  toRead -= bytes;
	  if (toRead == 0) done = true;
	} 
      }
    }

    (ipp->_data).move(utilLen);
    offset += utilLen;
    done = (done || (SEQ_ADD(tcpp->seq, offset) == finSeq));
    if (done) dispatch();
  }

 finished:
  tcpp->release();
  cleanPacket(tcpp);
  return eof;
}

void TCPReqFlowComponent::cleanup(void) 
{ 
  dispatch(); 
  cleanPacket(udpp); 
}

