/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <ctype.h>
#include <libpandora/conf/string.h>
	   }
#include <libpandora/util.h>
#include <pandora_components/tcppacket.h>
#include <pandora_components/ippacket.h>

#include "tcpallmergecomponent.h"

component_export(TCPAllMergeComponent, TCPPacket, TCPPacket);

bool TCPAllMergeComponent::add(Packet *pkt) 
{
  TCPPacket *tcpp2 = static_cast<TCPPacket *>(pkt);
  bool eof = tcpp2->eof;

  if (flush) return_clean(tcpp2);

  if (tcpp == NULL) {
    init(tcpp2);
  } else { 
    merge(tcpp2);
    cleanPacket(tcpp2);
  }    
  
  if (eof) dispatch();
  return eof;
}


void TCPAllMergeComponent::merge(TCPPacket *tcpp2)
{
  locatePacket(IPPacket, ipp2, tcpp2);
  pandora_assert(ipp2 != NULL);

  pandora_assert(ipp != NULL);
  pandora_assert(tcpp2 != tcpp);

  if (tcpp2->length != ipp2->dlength()) {
    pandora_error("TCP packet not captured in its totality, cannot proceed");
  }
  
  int rlen = ipp2->dlength();
  if (rlen == 0) return;

  int cap = (ipp->_data).getCapacity();

  while (rlen > (int) (ipp->_data).getSpace()) {
    cap *= 2;
    (ipp->_data).growUp(cap);
    
    if (limit > 0 && cap > limit) {
      dispatch();
      flush = true;
      return;
    }
  }

  (ipp->_data).write(ipp2->data(), rlen);

  tcpp->eof |= 		tcpp2->eof;
  tcpp->gap |= 		tcpp2->gap;
  tcpp->ack = 		tcpp2->ack;
  tcpp->length += 	rlen;
  ipp->length +=	rlen;
}

void TCPAllMergeComponent::init(TCPPacket *tcpp2)
{
  locatePacket(IPPacket, ipp2, tcpp2);
  pandora_assert(ipp2 != NULL);

  tcpp = tcpp2;
  ipp = ipp2;

  (ipp->_data).growUp(base_sz);  
}

void TCPAllMergeComponent::cleanup(void) 
{ 
  dispatch();
  flush = false;
}

void TCPAllMergeComponent::dispatch(void)
{
  if (tcpp == NULL) return;
  push(tcpp);
  tcpp = NULL;
}
