/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <fcntl.h>
#include <pandora_components/systrace.h>
	   }

#include "systracecomponent.h"
#include <libpandora/netutil.h>
#include <pandora_components/syscallpacket.h>

component_export(SystraceComponent,, SyscallPacket);

int SystraceComponent::init(void)
{
  if (kernel) {
    if (device == NULL) device = "/dev/trace/syscall";
    
    syscall_filter filter;

    filter.mask = 0;
    filter.task.uid = getuid();
    filter.task.pid = getpid();
    filter.truth = 0;
    filter.mask |= SYSCALL_FILTER_UID;
    
    if ((fd = open(device, O_RDONLY)) < 0) {
      pandora_perror(device);
    }
    
#if 0
    if (ioctl(fd, IOC_FILTER, &filter) < 0) {
      pandora_perror("ioctl");
    }
#endif
  } else {
    fd = openserver(2300, false, false);
    if (fd < 0) return ERROR_FILENO;
  }
  return fd;
}

bool SystraceComponent::process(void)
{
  syscall_hdr *header;
  const static size_t hlen = sizeof(syscall_hdr);

  if (kernel) {
    int n = read(fd, buf, sizeof(syscall_hdr));
    if (n != sizeof(syscall_hdr)) return true;
    header = (syscall_hdr *)buf;
    int len = header->len;
    if ((len > 0) && ((len + hlen) < sizeof(buf))) {
      if (read(fd, buf+hlen, len) != len) return true;
    }
  } else {
    int n = read(fd, buf, sizeof(buf));
    if (n < (int)hlen) return true;
    header = (syscall_hdr *)buf;
    if (n < (int)(hlen + header->len)) return true;
  }

  SyscallPacket *spp = new SyscallPacket(*header);
  if (!kernel) spp->setTimeStamp();
  if (header->len > 0) spp->read_args(buf+hlen);
  
  push(spp);

  return false;
}

void SystraceComponent::finish(void)
{
  if (fd > 0) {
    close(fd);
    fd = -1;
  }
}
