/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SYSCALL_PACKET_H
#define SYSCALL_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <sys/syscall.h>
#include <pandora_components/systrace.h>
	   }

#include <libpandora/packet.h>
#include <libpandora/text.h>
#include <libpandora/array.h>
#include <libpandora/multivalue.h>
#include <libpandora/serialize.h>


class SyscallPacket : public Packet {
public:
  enum syscallt_t { UNDEF =  -1,
		    READ =   SYS_read, 	 WRITE =  SYS_write, 
		    OPEN =   SYS_open, 	 CLOSE =  SYS_close, 
		    UNLINK = SYS_unlink, RENAME = SYS_rename, 
		    MKDIR =  SYS_mkdir,	 RMDIR =  SYS_rmdir
  };

  
  syscallt_t		type;
  int	   		retval;
  unsigned int		pid;
  unsigned int		uid;
  text			comm;
  text			cwd;
  Array<MultiValue>	args;

public:
  packet_init(SyscallPacket, 1);

public:
  SyscallPacket(syscallt_t t);
  SyscallPacket(const syscall_hdr &hdr);
  SyscallPacket(const SyscallPacket& x);
  SyscallPacket& operator= (const SyscallPacket& x);
  virtual ~SyscallPacket(void) { }

  void read_args(const char *str);

  virtual void print(ostream *f) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

serialEnum(SyscallPacket::syscallt_t);

#endif /* SYSCALL_PACKET_H */
